/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.packets.unsubscribe;

import com.google.common.collect.ImmutableList;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.extension.sdk.api.packets.unsubscribe.UnsubscribePacket;
import com.hivemq.extensions.packets.general.UserPropertiesImpl;
import com.hivemq.mqtt.message.unsubscribe.UNSUBSCRIBE;
import java.util.Objects;

public class UnsubscribePacketImpl
implements UnsubscribePacket {
    @NotNull
    final ImmutableList<String> topicFilters;
    @NotNull
    final UserPropertiesImpl userProperties;
    final int packetIdentifier;

    public UnsubscribePacketImpl(@NotNull ImmutableList<String> topicFilters, @NotNull UserPropertiesImpl userProperties, int packetIdentifier) {
        this.topicFilters = topicFilters;
        this.userProperties = userProperties;
        this.packetIdentifier = packetIdentifier;
    }

    public UnsubscribePacketImpl(@NotNull UNSUBSCRIBE unsubscribe) {
        this(unsubscribe.getTopics(), UserPropertiesImpl.of(unsubscribe.getUserProperties().asList()), unsubscribe.getPacketIdentifier());
    }

    @NotNull
    public ImmutableList<String> getTopicFilters() {
        return this.topicFilters;
    }

    @NotNull
    public UserPropertiesImpl getUserProperties() {
        return this.userProperties;
    }

    public int getPacketIdentifier() {
        return this.packetIdentifier;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UnsubscribePacketImpl)) {
            return false;
        }
        UnsubscribePacketImpl that = (UnsubscribePacketImpl)o;
        return this.topicFilters.equals(that.topicFilters) && this.userProperties.equals(that.userProperties) && this.packetIdentifier == that.packetIdentifier;
    }

    public int hashCode() {
        return Objects.hash(this.topicFilters, this.userProperties, this.packetIdentifier);
    }
}

