/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.services.auth;

import com.google.common.collect.ImmutableMap;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.services.auth.provider.AuthorizerProvider;
import com.hivemq.extensions.ExtensionPriorityComparator;
import com.hivemq.extensions.HiveMQExtension;
import com.hivemq.extensions.HiveMQExtensions;
import com.hivemq.extensions.services.auth.Authorizers;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class AuthorizersImpl
implements Authorizers {
    @NotNull
    private final @NotNull Map<@NotNull String, @NotNull AuthorizerProvider> authorizerProviderMap;
    @NotNull
    private final ReadWriteLock readWriteLock;
    @NotNull
    private final HiveMQExtensions hiveMQExtensions;

    @Inject
    public AuthorizersImpl(@NotNull HiveMQExtensions hiveMQExtensions) {
        this.hiveMQExtensions = hiveMQExtensions;
        this.authorizerProviderMap = new TreeMap<String, AuthorizerProvider>(new ExtensionPriorityComparator(hiveMQExtensions));
        this.readWriteLock = new ReentrantReadWriteLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAuthorizerProvider(@NotNull AuthorizerProvider authorizerProvider) {
        Lock writeLock = this.readWriteLock.writeLock();
        writeLock.lock();
        try {
            ClassLoader pluginClassloader = authorizerProvider.getClass().getClassLoader();
            HiveMQExtension plugin = this.hiveMQExtensions.getExtensionForClassloader(pluginClassloader);
            if (plugin != null) {
                this.authorizerProviderMap.put(plugin.getId(), authorizerProvider);
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    @Override
    @NotNull
    public @NotNull Map<@NotNull String, @NotNull AuthorizerProvider> getAuthorizerProviderMap() {
        Lock readLock = this.readWriteLock.readLock();
        readLock.lock();
        try {
            ImmutableMap immutableMap = ImmutableMap.copyOf(this.authorizerProviderMap);
            return immutableMap;
        }
        finally {
            readLock.unlock();
        }
    }

    @Override
    public boolean areAuthorizersAvailable() {
        Lock lock = this.readWriteLock.readLock();
        try {
            lock.lock();
            boolean bl = !this.authorizerProviderMap.isEmpty();
            return bl;
        }
        finally {
            lock.unlock();
        }
    }
}

