/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.services.builder;

import com.google.common.base.Preconditions;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.extension.sdk.api.packets.general.Qos;
import com.hivemq.util.Topics;
import com.hivemq.util.Utf8Utils;

public class PluginBuilderUtil {
    public static final int UTF_8_STRING_MAX_LENGTH = 65535;

    public static boolean isValidUtf8String(@NotNull String stringToValidate, boolean validateUTF8) {
        if (Utf8Utils.containsMustNotCharacters(stringToValidate)) {
            return false;
        }
        return !validateUTF8 || !Utf8Utils.hasControlOrNonCharacter(stringToValidate);
    }

    public static void checkMessageExpiryInterval(long messageExpiryInterval, long maxMessageExpiryInterval) {
        Preconditions.checkArgument((messageExpiryInterval <= maxMessageExpiryInterval ? 1 : 0) != 0, (Object)("Message expiry interval " + messageExpiryInterval + " not allowed. Maximum = " + maxMessageExpiryInterval));
        Preconditions.checkArgument((messageExpiryInterval > 0L ? 1 : 0) != 0, (Object)("Message expiry interval must be bigger than 0 was " + messageExpiryInterval + "."));
    }

    public static void checkResponseTopic(@Nullable String responseTopic, boolean validateUTF8) {
        if (responseTopic == null) {
            return;
        }
        PluginBuilderUtil.checkUtf8StringLength(responseTopic, "Response topic");
        if (!PluginBuilderUtil.isValidUtf8String(responseTopic, validateUTF8)) {
            throw new IllegalArgumentException("The response topic (" + responseTopic + ") is UTF-8 malformed");
        }
    }

    public static void checkReasonString(@Nullable String reasonString, boolean validateUTF8) {
        if (reasonString == null) {
            return;
        }
        PluginBuilderUtil.checkUtf8StringLength(reasonString, "Reason string");
        if (!PluginBuilderUtil.isValidUtf8String(reasonString, validateUTF8)) {
            throw new IllegalArgumentException("The reason string (" + reasonString + ") is UTF-8 malformed");
        }
    }

    public static void checkResponseInformation(@Nullable String responseInformation, boolean requestResponseInformation, boolean validateUTF8) {
        if (responseInformation == null) {
            return;
        }
        if (!requestResponseInformation) {
            throw new IllegalStateException("Response information must not be set if it was not requested in the CONNECT message");
        }
        PluginBuilderUtil.checkUtf8StringLength(responseInformation, "Response information");
        if (!PluginBuilderUtil.isValidUtf8String(responseInformation, validateUTF8)) {
            throw new IllegalArgumentException("The response information (" + responseInformation + ") is UTF-8 malformed");
        }
    }

    public static void checkServerReference(@Nullable String serverReference, boolean validateUTF8) {
        if (serverReference == null) {
            return;
        }
        PluginBuilderUtil.checkUtf8StringLength(serverReference, "Server reference");
        if (!PluginBuilderUtil.isValidUtf8String(serverReference, validateUTF8)) {
            throw new IllegalArgumentException("The server reference (" + serverReference + ") is UTF-8 malformed");
        }
    }

    public static void checkContentType(@Nullable String contentType, boolean validateUTF8) {
        if (contentType == null) {
            return;
        }
        PluginBuilderUtil.checkUtf8StringLength(contentType, "Content type");
        if (!PluginBuilderUtil.isValidUtf8String(contentType, validateUTF8)) {
            throw new IllegalArgumentException("The content type (" + contentType + ") is UTF-8 malformed");
        }
    }

    public static void checkUserProperty(@NotNull String name, @NotNull String value, boolean validateUTF8) {
        PluginBuilderUtil.checkUserPropertyName(name, validateUTF8);
        PluginBuilderUtil.checkUserPropertyValue(value, validateUTF8);
    }

    public static void checkUserPropertyName(@NotNull String name, boolean validateUTF8) {
        Preconditions.checkNotNull((Object)name, (Object)"Name must never be null");
        PluginBuilderUtil.checkUtf8StringLength(name, "User property name");
        if (!PluginBuilderUtil.isValidUtf8String(name, validateUTF8)) {
            throw new IllegalArgumentException("The user property name (" + name + ") is UTF-8 malformed");
        }
    }

    public static void checkUserPropertyValue(@NotNull String value, boolean validateUTF8) {
        Preconditions.checkNotNull((Object)value, (Object)"Value must never be null");
        PluginBuilderUtil.checkUtf8StringLength(value, "User property value");
        if (!PluginBuilderUtil.isValidUtf8String(value, validateUTF8)) {
            throw new IllegalArgumentException("The user property value (" + value + ") is UTF-8 malformed");
        }
    }

    public static void checkQos(@NotNull Qos qos, int maxQos) {
        Preconditions.checkNotNull((Object)qos, (Object)"QoS must not be null");
        if (qos.getQosNumber() > maxQos) {
            throw new IllegalArgumentException("QoS " + qos.getQosNumber() + " not allowed. Maximum = " + maxQos);
        }
    }

    public static void checkTopic(@NotNull String topic, int maxTopicLength, boolean validateUtf8) {
        Preconditions.checkNotNull((Object)topic, (Object)"Topic must not be null");
        Preconditions.checkArgument((topic.length() <= maxTopicLength ? 1 : 0) != 0, (Object)("Topic length must not exceed '" + maxTopicLength + "' characters, but has '" + topic.length() + "' characters"));
        if (!Topics.isValidTopicToPublish(topic)) {
            throw new IllegalArgumentException("The topic (" + topic + ") is invalid for retained PUBLISH messages");
        }
        if (!PluginBuilderUtil.isValidUtf8String(topic, validateUtf8)) {
            throw new IllegalArgumentException("The topic (" + topic + ") is UTF-8 malformed");
        }
    }

    public static void checkClientIdentifier(@Nullable String clientIdentifier, boolean validateUtf8) {
        if (clientIdentifier == null) {
            return;
        }
        PluginBuilderUtil.checkUtf8StringLength(clientIdentifier, "Client ID");
        if (!PluginBuilderUtil.isValidUtf8String(clientIdentifier, validateUtf8)) {
            throw new IllegalArgumentException("The client ID (" + clientIdentifier + ") is UTF-8 malformed");
        }
        Preconditions.checkArgument((!clientIdentifier.isEmpty() ? 1 : 0) != 0, (Object)"Client ID must not be empty");
    }

    private static void checkUtf8StringLength(@NotNull String utf8String, @NotNull String type) {
        if (utf8String.length() > 65535) {
            throw new IllegalArgumentException(type + " length must not exceed '65535' characters, but has '" + utf8String.length() + "' characters");
        }
    }
}

