/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.services.executor;

import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.services.CompletableScheduledFuture;
import com.hivemq.extension.sdk.api.services.ManagedExtensionExecutorService;
import com.hivemq.extensions.HiveMQExtensions;
import com.hivemq.extensions.services.executor.CompletableScheduledFutureImpl;
import com.hivemq.extensions.services.executor.GlobalManagedExtensionExecutorService;
import com.hivemq.extensions.services.executor.WrappedCallable;
import com.hivemq.extensions.services.executor.WrappedRunnable;
import com.hivemq.extensions.services.executor.WrappedRunnableWithResult;
import com.hivemq.extensions.services.executor.WrappedScheduledRunnable;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;

public class ManagedExecutorServicePerExtension
implements ManagedExtensionExecutorService {
    @NotNull
    private final GlobalManagedExtensionExecutorService managedPluginExecutorService;
    @NotNull
    private final ClassLoader classLoader;
    @NotNull
    private final HiveMQExtensions hiveMQExtensions;

    public ManagedExecutorServicePerExtension(@NotNull GlobalManagedExtensionExecutorService managedPluginExecutorService, @NotNull ClassLoader classLoader, @NotNull HiveMQExtensions hiveMQExtensions) {
        this.managedPluginExecutorService = managedPluginExecutorService;
        this.classLoader = classLoader;
        this.hiveMQExtensions = hiveMQExtensions;
    }

    public void execute(@NotNull Runnable command) {
        if (!this.isShutdown()) {
            this.managedPluginExecutorService.execute(new WrappedRunnable(command, this.classLoader, null));
        }
    }

    @NotNull
    public CompletableScheduledFuture<?> schedule(@NotNull Runnable command, long delay, @NotNull TimeUnit unit) {
        CompletableScheduledFutureImpl completableScheduledFuture = new CompletableScheduledFutureImpl();
        ScheduledFuture<?> scheduledFuture = this.managedPluginExecutorService.schedule(new WrappedRunnable(command, this.classLoader, (CompletableFuture<?>)((Object)completableScheduledFuture)), delay, unit);
        completableScheduledFuture.setScheduledFuture(scheduledFuture);
        return completableScheduledFuture;
    }

    @NotNull
    public <V> CompletableScheduledFuture<V> schedule(@NotNull Callable<V> callable, long delay, @NotNull TimeUnit unit) {
        CompletableScheduledFutureImpl completableScheduledFuture = new CompletableScheduledFutureImpl();
        ScheduledFuture<V> scheduledFuture = this.managedPluginExecutorService.schedule(new WrappedCallable<V>(callable, this.classLoader, completableScheduledFuture), delay, unit);
        completableScheduledFuture.setScheduledFuture(scheduledFuture);
        return completableScheduledFuture;
    }

    @NotNull
    public CompletableScheduledFuture<?> scheduleAtFixedRate(@NotNull Runnable command, long initialDelay, long period, @NotNull TimeUnit unit) {
        CompletableScheduledFutureImpl completableScheduledFuture = new CompletableScheduledFutureImpl();
        ScheduledFuture<?> scheduledFuture = this.managedPluginExecutorService.scheduleAtFixedRate(new WrappedScheduledRunnable(command, this.classLoader, completableScheduledFuture, this.hiveMQExtensions), initialDelay, period, unit);
        completableScheduledFuture.setScheduledFuture(scheduledFuture);
        return completableScheduledFuture;
    }

    @NotNull
    public CompletableScheduledFuture<?> scheduleWithFixedDelay(@NotNull Runnable command, long initialDelay, long delay, @NotNull TimeUnit unit) {
        CompletableScheduledFutureImpl completableScheduledFuture = new CompletableScheduledFutureImpl();
        ScheduledFuture<?> scheduledFuture = this.managedPluginExecutorService.scheduleWithFixedDelay(new WrappedScheduledRunnable(command, this.classLoader, completableScheduledFuture, this.hiveMQExtensions), initialDelay, delay, unit);
        completableScheduledFuture.setScheduledFuture(scheduledFuture);
        return completableScheduledFuture;
    }

    public boolean isShutdown() {
        return this.managedPluginExecutorService.isShutdown();
    }

    public boolean isTerminated() {
        return this.managedPluginExecutorService.isTerminated();
    }

    public boolean awaitTermination(long timeout, @NotNull TimeUnit unit) throws InterruptedException {
        return this.managedPluginExecutorService.awaitTermination(timeout, unit);
    }

    @NotNull
    public <T> CompletableFuture<T> submit(@NotNull Callable<T> task) {
        CompletableFuture completableFuture = new CompletableFuture();
        this.managedPluginExecutorService.submit(new WrappedCallable<T>(task, this.classLoader, completableFuture));
        return completableFuture;
    }

    @NotNull
    public <T> CompletableFuture<T> submit(@NotNull Runnable task, @NotNull T result) {
        CompletableFuture completableFuture = new CompletableFuture();
        this.managedPluginExecutorService.submit(new WrappedRunnableWithResult(task, this.classLoader, completableFuture, result), result);
        return completableFuture;
    }

    @NotNull
    public CompletableFuture<?> submit(@NotNull Runnable task) {
        CompletableFuture completableFuture = new CompletableFuture();
        this.managedPluginExecutorService.submit(new WrappedRunnable(task, this.classLoader, completableFuture));
        return completableFuture;
    }

    @NotNull
    public <T> List<Future<T>> invokeAll(@NotNull Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.managedPluginExecutorService.invokeAll(tasks.stream().map(callable -> new WrappedCallable(callable, this.classLoader, null)).collect(Collectors.toList()));
    }

    @NotNull
    public <T> List<Future<T>> invokeAll(@NotNull Collection<? extends Callable<T>> tasks, long timeout, @NotNull TimeUnit unit) throws InterruptedException {
        return this.managedPluginExecutorService.invokeAll(tasks.stream().map(callable -> new WrappedCallable(callable, this.classLoader, null)).collect(Collectors.toList()), timeout, unit);
    }

    @NotNull
    public <T> T invokeAny(@NotNull Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return this.managedPluginExecutorService.invokeAny(tasks.stream().map(callable -> new WrappedCallable(callable, this.classLoader, null)).collect(Collectors.toList()));
    }

    @NotNull
    public <T> T invokeAny(@NotNull Collection<? extends Callable<T>> tasks, long timeout, @NotNull TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.managedPluginExecutorService.invokeAny(tasks.stream().map(callable -> new WrappedCallable(callable, this.classLoader, null)).collect(Collectors.toList()), timeout, unit);
    }
}

