/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.services.executor;

import com.hivemq.common.shutdown.HiveMQShutdownHook;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extensions.services.executor.GlobalManagedExtensionExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedPluginExecutorShutdownHook
implements HiveMQShutdownHook {
    private static final Logger log = LoggerFactory.getLogger(ManagedPluginExecutorShutdownHook.class);
    @NotNull
    private final GlobalManagedExtensionExecutorService scheduledExecutorService;
    private final int timeout;

    public ManagedPluginExecutorShutdownHook(@NotNull GlobalManagedExtensionExecutorService scheduledExecutorService, int timeout) {
        this.scheduledExecutorService = scheduledExecutorService;
        this.timeout = timeout;
    }

    @Override
    @NotNull
    public String name() {
        return "ManagedExtensionExecutorService shutdown";
    }

    @Override
    @NotNull
    public HiveMQShutdownHook.Priority priority() {
        return HiveMQShutdownHook.Priority.DOES_NOT_MATTER;
    }

    @Override
    public void run() {
        log.debug("Shutting down managed extension executor service");
        this.scheduledExecutorService.shutdown();
        try {
            if (!this.scheduledExecutorService.awaitTermination(this.timeout, TimeUnit.SECONDS)) {
                this.scheduledExecutorService.shutdownNow();
                log.warn("Termination of managed extension executor service timed out after {} seconds. Enforcing shutdown.", (Object)this.timeout);
            }
        }
        catch (InterruptedException ex) {
            this.scheduledExecutorService.shutdownNow();
            log.warn("Not able to wait for managed extension executor service shutdown. Enforcing shutdown.", (Throwable)ex);
        }
    }
}

