/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.services.executor;

import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import java.util.concurrent.CompletableFuture;

public class WrappedRunnable
implements Runnable {
    @NotNull
    private final Runnable runnable;
    @NotNull
    private final ClassLoader classLoader;
    @Nullable
    private final CompletableFuture<?> future;

    WrappedRunnable(@NotNull Runnable runnable, @NotNull ClassLoader classLoader, @Nullable CompletableFuture<?> future) {
        this.runnable = runnable;
        this.classLoader = classLoader;
        this.future = future;
    }

    @Override
    public void run() {
        ClassLoader previousClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.classLoader);
            this.runnable.run();
            if (this.future != null) {
                this.future.complete(null);
            }
        }
        catch (Throwable t) {
            if (this.future != null) {
                this.future.completeExceptionally(t);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(previousClassLoader);
        }
    }
}

