/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.services.executor;

import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.services.CompletableScheduledFuture;
import com.hivemq.extensions.HiveMQExtensions;

public class WrappedScheduledRunnable
implements Runnable {
    @NotNull
    private final Runnable runnable;
    @NotNull
    private final ClassLoader classLoader;
    @NotNull
    private final CompletableScheduledFuture<?> future;
    @NotNull
    private final HiveMQExtensions hiveMQExtensions;

    WrappedScheduledRunnable(@NotNull Runnable runnable, @NotNull ClassLoader classLoader, @NotNull CompletableScheduledFuture<?> future, @NotNull HiveMQExtensions hiveMQExtensions) {
        this.runnable = runnable;
        this.classLoader = classLoader;
        this.future = future;
        this.hiveMQExtensions = hiveMQExtensions;
    }

    @Override
    public void run() {
        if (this.hiveMQExtensions.getExtensionForClassloader(this.classLoader) == null && !this.future.isCancelled()) {
            this.future.cancel(true);
        }
        ClassLoader previousClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.classLoader);
            this.runnable.run();
        }
        catch (Throwable t) {
            this.future.completeExceptionally(t);
            throw t;
        }
        finally {
            Thread.currentThread().setContextClassLoader(previousClassLoader);
        }
    }
}

