/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.services.publish;

import com.google.common.base.Preconditions;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.extension.sdk.api.packets.general.Qos;
import com.hivemq.extension.sdk.api.packets.publish.PayloadFormatIndicator;
import com.hivemq.extension.sdk.api.services.publish.Publish;
import com.hivemq.extensions.packets.general.UserPropertiesImpl;
import java.nio.ByteBuffer;
import java.util.Optional;

public class PublishImpl
implements Publish {
    @NotNull
    private final Qos qos;
    private final boolean retained;
    @NotNull
    private final String topic;
    @Nullable
    private final PayloadFormatIndicator payloadFormatIndicator;
    @Nullable
    private final Long messageExpiryInterval;
    @Nullable
    private final String responseTopic;
    @Nullable
    private final ByteBuffer correlationData;
    @Nullable
    private final String contentType;
    @Nullable
    private final ByteBuffer payload;
    @NotNull
    private final UserPropertiesImpl userProperties;

    public PublishImpl(@NotNull Qos qos, boolean retained, @NotNull String topic, @Nullable PayloadFormatIndicator payloadFormatIndicator, @Nullable Long messageExpiryInterval, @Nullable String responseTopic, @Nullable ByteBuffer correlationData, @Nullable String contentType, @Nullable ByteBuffer payload, @NotNull UserPropertiesImpl userProperties) {
        Preconditions.checkNotNull((Object)qos, (Object)"QoS must never be null");
        Preconditions.checkNotNull((Object)topic, (Object)"Topic must never be null");
        Preconditions.checkNotNull((Object)userProperties, (Object)"User properties must never be null");
        this.qos = qos;
        this.retained = retained;
        this.topic = topic;
        this.payloadFormatIndicator = payloadFormatIndicator;
        this.messageExpiryInterval = messageExpiryInterval;
        this.responseTopic = responseTopic;
        this.correlationData = correlationData;
        this.contentType = contentType;
        this.payload = payload;
        this.userProperties = userProperties;
    }

    @NotNull
    public Qos getQos() {
        return this.qos;
    }

    public boolean getRetain() {
        return this.retained;
    }

    @NotNull
    public String getTopic() {
        return this.topic;
    }

    @NotNull
    public Optional<PayloadFormatIndicator> getPayloadFormatIndicator() {
        return Optional.ofNullable(this.payloadFormatIndicator);
    }

    @NotNull
    public Optional<Long> getMessageExpiryInterval() {
        return Optional.ofNullable(this.messageExpiryInterval);
    }

    @NotNull
    public Optional<String> getResponseTopic() {
        return Optional.ofNullable(this.responseTopic);
    }

    @NotNull
    public Optional<ByteBuffer> getCorrelationData() {
        return Optional.ofNullable(this.correlationData);
    }

    @NotNull
    public Optional<String> getContentType() {
        return Optional.ofNullable(this.contentType);
    }

    @NotNull
    public Optional<ByteBuffer> getPayload() {
        return Optional.ofNullable(this.payload);
    }

    @NotNull
    public UserPropertiesImpl getUserProperties() {
        return this.userProperties;
    }
}

