/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.limitation;

import com.hivemq.configuration.service.InternalConfigurations;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.limitation.TopicAliasLimiter;
import java.util.concurrent.atomic.AtomicLong;
import javax.inject.Singleton;

@Singleton
public class TopicAliasLimiterImpl
implements TopicAliasLimiter {
    @NotNull
    private final AtomicLong memoryUsage = new AtomicLong(0L);
    @NotNull
    private final AtomicLong topicAliasesTotal = new AtomicLong(0L);
    private final int memorySoftLimit = InternalConfigurations.TOPIC_ALIAS_GLOBAL_MEMORY_SOFT_LIMIT_BYTES.get();
    private final int memoryHardLimit = InternalConfigurations.TOPIC_ALIAS_GLOBAL_MEMORY_HARD_LIMIT_BYTES.get();

    @Override
    public boolean aliasesAvailable() {
        return this.memoryUsage.get() < (long)this.memorySoftLimit;
    }

    @Override
    public boolean limitExceeded() {
        return this.memoryUsage.get() > (long)this.memoryHardLimit;
    }

    @Override
    public void initUsage(int size) {
        this.memoryUsage.addAndGet(size * 4);
    }

    @Override
    public void addUsage(@NotNull String topic) {
        this.memoryUsage.addAndGet(this.getEstimatedSize(topic));
        this.topicAliasesTotal.incrementAndGet();
    }

    @Override
    public void removeUsage(String ... topics) {
        for (String topic : topics) {
            if (topic == null) continue;
            this.memoryUsage.addAndGet(-1 * this.getEstimatedSize(topic));
            this.topicAliasesTotal.decrementAndGet();
        }
    }

    @Override
    public void finishUsage(String ... topics) {
        this.memoryUsage.addAndGet(topics.length * -4);
        this.removeUsage(topics);
    }

    private int getEstimatedSize(@NotNull String topic) {
        return 38 + topic.length() * 2;
    }
}

