/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.metrics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricRegistry;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.metrics.HiveMQMetrics;
import javax.inject.Singleton;

@Singleton
public class MetricsHolder {
    @NotNull
    private final MetricRegistry metricRegistry;
    @NotNull
    private final Counter incomingMessageCounter;
    @NotNull
    private final Counter outgoingMessageCounter;
    @NotNull
    private final Counter incomingConnectCounter;
    @NotNull
    private final Counter incomingPublishCounter;
    @NotNull
    private final Counter outgoingPublishCounter;
    @NotNull
    private final Counter droppedMessageCounter;
    @NotNull
    private final Counter subscriptionCounter;
    @NotNull
    private final Counter closedConnectionsCounter;
    @NotNull
    private final Counter channelNotWritableCounter;
    @NotNull
    private final Counter storedWillMessagesCount;
    @NotNull
    private final Counter publishedWillMessagesCount;

    public MetricsHolder(@NotNull MetricRegistry metricRegistry) {
        this.metricRegistry = metricRegistry;
        this.incomingMessageCounter = metricRegistry.counter(HiveMQMetrics.INCOMING_MESSAGE_COUNT.name());
        this.outgoingMessageCounter = metricRegistry.counter(HiveMQMetrics.OUTGOING_MESSAGE_COUNT.name());
        this.incomingConnectCounter = metricRegistry.counter(HiveMQMetrics.INCOMING_CONNECT_COUNT.name());
        this.incomingPublishCounter = metricRegistry.counter(HiveMQMetrics.INCOMING_PUBLISH_COUNT.name());
        this.outgoingPublishCounter = metricRegistry.counter(HiveMQMetrics.OUTGOING_PUBLISH_COUNT.name());
        this.droppedMessageCounter = metricRegistry.counter(HiveMQMetrics.DROPPED_MESSAGE_COUNT.name());
        this.closedConnectionsCounter = metricRegistry.counter(HiveMQMetrics.CONNECTIONS_CLOSED_COUNT.name());
        this.subscriptionCounter = metricRegistry.counter(HiveMQMetrics.SUBSCRIPTIONS_CURRENT.name());
        this.channelNotWritableCounter = metricRegistry.counter(HiveMQMetrics.MQTT_CONNECTION_NOT_WRITABLE_CURRENT.name());
        this.storedWillMessagesCount = metricRegistry.counter(HiveMQMetrics.WILL_MESSAGE_COUNT.name());
        this.publishedWillMessagesCount = metricRegistry.counter(HiveMQMetrics.WILL_MESSAGE_PUBLISHED_COUNT_TOTAL.name());
    }

    @NotNull
    public MetricRegistry getMetricRegistry() {
        return this.metricRegistry;
    }

    @NotNull
    public Counter getIncomingMessageCounter() {
        return this.incomingMessageCounter;
    }

    @NotNull
    public Counter getOutgoingMessageCounter() {
        return this.outgoingMessageCounter;
    }

    @NotNull
    public Counter getIncomingConnectCounter() {
        return this.incomingConnectCounter;
    }

    @NotNull
    public Counter getIncomingPublishCounter() {
        return this.incomingPublishCounter;
    }

    @NotNull
    public Counter getOutgoingPublishCounter() {
        return this.outgoingPublishCounter;
    }

    @NotNull
    public Counter getDroppedMessageCounter() {
        return this.droppedMessageCounter;
    }

    @NotNull
    public Counter getSubscriptionCounter() {
        return this.subscriptionCounter;
    }

    @NotNull
    public Counter getClosedConnectionsCounter() {
        return this.closedConnectionsCounter;
    }

    @NotNull
    public Counter getChannelNotWritableCounter() {
        return this.channelNotWritableCounter;
    }

    @NotNull
    public Counter getStoredWillMessagesCount() {
        return this.storedWillMessagesCount;
    }

    @NotNull
    public Counter getPublishedWillMessagesCount() {
        return this.publishedWillMessagesCount;
    }
}

