/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.migration;

import com.hivemq.configuration.info.SystemInformation;
import com.hivemq.configuration.service.InternalConfigurations;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.migration.meta.MetaFileService;
import com.hivemq.migration.meta.MetaInformation;
import com.hivemq.migration.meta.PersistenceType;

class MigrationFinisher {
    @NotNull
    private final SystemInformation systemInformation;
    @NotNull
    private final PersistenceType retainedType;
    @NotNull
    private final PersistenceType payloadType;

    public MigrationFinisher(@NotNull SystemInformation systemInformation) {
        this.systemInformation = systemInformation;
        this.retainedType = InternalConfigurations.RETAINED_MESSAGE_PERSISTENCE_TYPE.get();
        this.payloadType = InternalConfigurations.PAYLOAD_PERSISTENCE_TYPE.get();
    }

    public void finishMigration() {
        this.saveNewStateToMetaFile();
    }

    private void saveNewStateToMetaFile() {
        MetaInformation metaFile = MetaFileService.readMetaFile(this.systemInformation);
        metaFile.setHivemqVersion(this.systemInformation.getHiveMQVersion());
        metaFile.setClientSessionPersistenceVersion("040000");
        metaFile.setQueuedMessagesPersistenceVersion("040500");
        metaFile.setSubscriptionPersistenceVersion("040000");
        metaFile.setRetainedMessagesPersistenceVersion(this.retainedType == PersistenceType.FILE_NATIVE ? "040500_R" : "040500");
        metaFile.setPublishPayloadPersistenceVersion(this.payloadType == PersistenceType.FILE_NATIVE ? "040500_R" : "040500");
        metaFile.setRetainedMessagesPersistenceType(this.retainedType);
        metaFile.setPublishPayloadPersistenceType(this.payloadType);
        MetaFileService.writeMetaFile(this.systemInformation, metaFile);
    }
}

