/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.migration;

import com.google.common.base.Preconditions;
import com.google.inject.Injector;
import com.hivemq.configuration.info.SystemInformation;
import com.hivemq.configuration.service.InternalConfigurations;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.migration.MigrationFinisher;
import com.hivemq.migration.MigrationUnit;
import com.hivemq.migration.meta.MetaFileService;
import com.hivemq.migration.meta.MetaInformation;
import com.hivemq.migration.meta.PersistenceType;
import com.hivemq.migration.persistence.PersistenceMigrator;
import java.io.File;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Migrations {
    public static final String MIGRATION_LOGGER_NAME = "migrations";
    private static final Logger log = LoggerFactory.getLogger(Migrations.class);
    private static final Logger MIGRATION_LOGGER = LoggerFactory.getLogger((String)"migrations");

    @NotNull
    public static Map<MigrationUnit, PersistenceType> checkForTypeMigration(@NotNull SystemInformation systemInformation) {
        PersistenceType previousRetainedType;
        PersistenceType previousPayloadType;
        MIGRATION_LOGGER.info("Checking for migrations (HiveMQ version {}).", (Object)systemInformation.getHiveMQVersion());
        MetaInformation metaInformation = MetaFileService.readMetaFile(systemInformation);
        if (systemInformation.getHiveMQVersion().equals("Development Snapshot")) {
            MIGRATION_LOGGER.info("Skipping migration because it is a Development Snapshot.");
            return Collections.emptyMap();
        }
        if (!metaInformation.isDataFolderPresent()) {
            log.trace("No data folder present, skip migrations.");
            MIGRATION_LOGGER.info("Skipping migration because no data folder is present.");
            return Collections.emptyMap();
        }
        if (!metaInformation.isPersistenceFolderPresent()) {
            log.trace("No persistence folder present, skip migrations.");
            MIGRATION_LOGGER.info("Skipping migration because no persistence folder is present.");
            return Collections.emptyMap();
        }
        if (!metaInformation.isMetaFilePresent()) {
            log.trace("No meta file present, assuming HiveMQ version 2019.1 => Migration needed.");
            MIGRATION_LOGGER.info("No meta file present, assuming HiveMQ version 2019.1 => Migration needed.");
            previousPayloadType = PersistenceType.FILE;
            previousRetainedType = PersistenceType.FILE;
            MetaInformation newMetaInformation = new MetaInformation();
            newMetaInformation.setPublishPayloadPersistenceType(previousPayloadType);
            newMetaInformation.setRetainedMessagesPersistenceType(previousRetainedType);
            MetaFileService.writeMetaFile(systemInformation, newMetaInformation);
        } else {
            Preconditions.checkNotNull((Object)((Object)metaInformation.getRetainedMessagesPersistenceType()));
            Preconditions.checkNotNull((Object)((Object)metaInformation.getPublishPayloadPersistenceType()));
            previousRetainedType = metaInformation.getRetainedMessagesPersistenceType();
            previousPayloadType = metaInformation.getPublishPayloadPersistenceType();
        }
        PersistenceType currentRetainedType = InternalConfigurations.RETAINED_MESSAGE_PERSISTENCE_TYPE.get();
        PersistenceType currentPayloadType = InternalConfigurations.PAYLOAD_PERSISTENCE_TYPE.get();
        EnumMap<MigrationUnit, PersistenceType> neededMigrations = new EnumMap<MigrationUnit, PersistenceType>(MigrationUnit.class);
        if (!previousPayloadType.equals((Object)currentPayloadType) && Migrations.isPreviousPersistenceExistent(systemInformation, "publish_payload_store")) {
            neededMigrations.put(MigrationUnit.FILE_PERSISTENCE_PUBLISH_PAYLOAD, currentPayloadType);
        }
        if (!previousRetainedType.equals((Object)currentRetainedType) && Migrations.isPreviousPersistenceExistent(systemInformation, "retained_messages")) {
            neededMigrations.put(MigrationUnit.FILE_PERSISTENCE_RETAINED_MESSAGES, currentRetainedType);
        }
        if (neededMigrations.isEmpty()) {
            MIGRATION_LOGGER.info("Nothing to migrate found.");
        } else {
            MIGRATION_LOGGER.info("Found following needed migrations: {}", neededMigrations);
        }
        return neededMigrations;
    }

    public static Set<MigrationUnit> checkForValueMigration(@NotNull SystemInformation systemInformation) {
        MIGRATION_LOGGER.info("Checking for value migrations (HiveMQ version {}).", (Object)systemInformation.getHiveMQVersion());
        if (systemInformation.getHiveMQVersion().equals("Development Snapshot")) {
            MIGRATION_LOGGER.info("Skipping migration because it is a Development Snapshot.");
            return Collections.emptySet();
        }
        MetaInformation metaInformation = MetaFileService.readMetaFile(systemInformation);
        if (!metaInformation.isDataFolderPresent()) {
            log.trace("No data folder present, skip migrations.");
            MIGRATION_LOGGER.info("Skipping migration because no data folder is present.");
            return Collections.emptySet();
        }
        if (!metaInformation.isPersistenceFolderPresent()) {
            log.trace("No persistence folder present, skip migrations.");
            MIGRATION_LOGGER.info("Skipping migration because no persistence folder is present.");
            return Collections.emptySet();
        }
        TreeSet<MigrationUnit> neededMigrations = new TreeSet<MigrationUnit>();
        if (Migrations.retainedNeeded(metaInformation, systemInformation)) {
            neededMigrations.add(MigrationUnit.PAYLOAD_ID_RETAINED_MESSAGES);
        }
        if (Migrations.queuedNeeded(metaInformation, systemInformation)) {
            neededMigrations.add(MigrationUnit.PAYLOAD_ID_CLIENT_QUEUE);
        }
        if (neededMigrations.isEmpty()) {
            MIGRATION_LOGGER.info("Nothing to migrate found.");
        } else {
            MIGRATION_LOGGER.info("Found following needed migrations: {}", neededMigrations);
        }
        return neededMigrations;
    }

    private static boolean retainedNeeded(@NotNull MetaInformation metaInformation, @NotNull SystemInformation systemInformation) {
        String previousRetainedVersion = metaInformation.getRetainedMessagesPersistenceVersion() == null ? "NOT_SET" : metaInformation.getRetainedMessagesPersistenceVersion();
        PersistenceType currentRetainedType = InternalConfigurations.RETAINED_MESSAGE_PERSISTENCE_TYPE.get();
        String currentRetainedVersion = currentRetainedType == PersistenceType.FILE ? "040500" : "040500_R";
        return !previousRetainedVersion.equals(currentRetainedVersion) && Migrations.isPreviousPersistenceExistent(systemInformation, "retained_messages");
    }

    private static boolean queuedNeeded(@NotNull MetaInformation metaInformation, @NotNull SystemInformation systemInformation) {
        String previousQueuedVersion = metaInformation.getQueuedMessagesPersistenceVersion() == null ? "NOT_SET" : metaInformation.getQueuedMessagesPersistenceVersion();
        String currentQueuedVersion = "040500";
        return !previousQueuedVersion.equals("040500") && Migrations.isPreviousPersistenceExistent(systemInformation, "client_queue");
    }

    private static boolean isPreviousPersistenceExistent(@NotNull SystemInformation systemInformation, @NotNull String persistence) {
        return new File(String.valueOf(systemInformation.getDataFolder()) + File.separator + "persistence", persistence).exists();
    }

    public static void migrate(Injector persistenceInjector, @NotNull Map<MigrationUnit, PersistenceType> typeMigrations, @NotNull Set<MigrationUnit> valueMigrations) {
        MIGRATION_LOGGER.info("Start migration.");
        PersistenceMigrator persistenceMigrator = (PersistenceMigrator)persistenceInjector.getInstance(PersistenceMigrator.class);
        persistenceMigrator.migratePersistenceValues(valueMigrations);
        persistenceMigrator.migratePersistenceTypes(typeMigrations);
        persistenceMigrator.closeAllLegacyPersistences();
    }

    public static void afterMigration(@NotNull SystemInformation systemInformation) {
        MigrationFinisher finisher = new MigrationFinisher(systemInformation);
        finisher.finishMigration();
        MIGRATION_LOGGER.info("Finished migration.");
    }
}

