/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.migration.meta;

import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.migration.meta.MetaInformation;
import com.hivemq.migration.meta.PersistenceType;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;

public class MetaInformationSerializer {
    @NotNull
    public byte[] serialize(@NotNull MetaInformation metaInformation) {
        byte[] hivemqVersion = metaInformation.getHivemqVersion() != null ? metaInformation.getHivemqVersion().getBytes(StandardCharsets.UTF_8) : new byte[]{};
        byte[] publishPayloadPersistenceVersion = metaInformation.getPublishPayloadPersistenceVersion() != null ? metaInformation.getPublishPayloadPersistenceVersion().getBytes(StandardCharsets.UTF_8) : new byte[]{};
        byte[] retainedMessagesPersistenceVersion = metaInformation.getRetainedMessagesPersistenceVersion() != null ? metaInformation.getRetainedMessagesPersistenceVersion().getBytes(StandardCharsets.UTF_8) : new byte[]{};
        byte[] subscriptionPersistenceVersion = metaInformation.getSubscriptionPersistenceVersion() != null ? metaInformation.getSubscriptionPersistenceVersion().getBytes(StandardCharsets.UTF_8) : new byte[]{};
        byte[] clientSessionPersistenceVersion = metaInformation.getClientSessionPersistenceVersion() != null ? metaInformation.getClientSessionPersistenceVersion().getBytes(StandardCharsets.UTF_8) : new byte[]{};
        byte[] queuedMessagesPersistenceVersion = metaInformation.getQueuedMessagesPersistenceVersion() != null ? metaInformation.getQueuedMessagesPersistenceVersion().getBytes(StandardCharsets.UTF_8) : new byte[]{};
        byte retainedMessagesPersistenceType = metaInformation.getRetainedMessagesPersistenceType() != null ? (byte)metaInformation.getRetainedMessagesPersistenceType().ordinal() : (byte)-1;
        byte publishPayloadPersistenceType = metaInformation.getPublishPayloadPersistenceType() != null ? (byte)metaInformation.getPublishPayloadPersistenceType().ordinal() : (byte)-1;
        int bufferSize = 24 + hivemqVersion.length + publishPayloadPersistenceVersion.length + retainedMessagesPersistenceVersion.length + subscriptionPersistenceVersion.length + clientSessionPersistenceVersion.length + queuedMessagesPersistenceVersion.length + 2;
        ByteBuffer byteBuffer = ByteBuffer.allocate(bufferSize);
        this.putByteArray(hivemqVersion, byteBuffer);
        this.putByteArray(publishPayloadPersistenceVersion, byteBuffer);
        this.putByteArray(retainedMessagesPersistenceVersion, byteBuffer);
        this.putByteArray(subscriptionPersistenceVersion, byteBuffer);
        this.putByteArray(clientSessionPersistenceVersion, byteBuffer);
        this.putByteArray(queuedMessagesPersistenceVersion, byteBuffer);
        byteBuffer.put(retainedMessagesPersistenceType);
        byteBuffer.put(publishPayloadPersistenceType);
        return byteBuffer.array();
    }

    private void putByteArray(byte[] source, @NotNull ByteBuffer destination) {
        if (source.length > 0) {
            destination.putInt(source.length);
            destination.put(source);
        } else {
            destination.putInt(0);
        }
    }

    @NotNull
    public MetaInformation deserialize(@NotNull byte[] metaBytes) {
        ByteBuffer metaFileAsByteBuffer = ByteBuffer.wrap(metaBytes);
        String hivemqVersion = this.getStringFromBuffer(metaFileAsByteBuffer);
        String publishPayloadPersistenceVersion = this.getStringFromBuffer(metaFileAsByteBuffer);
        String retainedMessagesPersistenceVersion = this.getStringFromBuffer(metaFileAsByteBuffer);
        String subscriptionPersistenceVersion = this.getStringFromBuffer(metaFileAsByteBuffer);
        String clientSessionPersistenceVersion = this.getStringFromBuffer(metaFileAsByteBuffer);
        String queuedMessagesPersistenceVersion = this.getStringFromBuffer(metaFileAsByteBuffer);
        PersistenceType retainedMessagePersistenceType = this.getTypeFromBuffer(metaFileAsByteBuffer);
        PersistenceType publishPayloadPersistenceType = this.getTypeFromBuffer(metaFileAsByteBuffer);
        MetaInformation metaInformation = new MetaInformation();
        metaInformation.setHivemqVersion(hivemqVersion);
        metaInformation.setClientSessionPersistenceVersion(clientSessionPersistenceVersion);
        metaInformation.setQueuedMessagesPersistenceVersion(queuedMessagesPersistenceVersion);
        metaInformation.setRetainedMessagesPersistenceVersion(retainedMessagesPersistenceVersion);
        metaInformation.setSubscriptionPersistenceVersion(subscriptionPersistenceVersion);
        metaInformation.setPublishPayloadPersistenceVersion(publishPayloadPersistenceVersion);
        metaInformation.setRetainedMessagesPersistenceType(retainedMessagePersistenceType);
        metaInformation.setPublishPayloadPersistenceType(publishPayloadPersistenceType);
        metaInformation.setMetaFilePresent(true);
        metaInformation.setPersistenceFolderPresent(true);
        metaInformation.setDataFolderPresent(true);
        return metaInformation;
    }

    private PersistenceType getTypeFromBuffer(ByteBuffer metaFileAsByteBuffer) {
        byte typeAsByte = metaFileAsByteBuffer.get();
        return typeAsByte > -1 ? PersistenceType.forCode(typeAsByte) : null;
    }

    @Nullable
    private String getStringFromBuffer(ByteBuffer metaFileAsByteBuffer) {
        int stringLength = metaFileAsByteBuffer.getInt();
        if (stringLength == 0) {
            return null;
        }
        byte[] versionAsByteArray = new byte[stringLength];
        metaFileAsByteBuffer.get(versionAsByteArray, 0, stringLength);
        return new String(versionAsByteArray, StandardCharsets.UTF_8);
    }
}

