/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.migration.persistence.legacy;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.hivemq.bootstrap.ioc.lazysingleton.LazySingleton;
import com.hivemq.configuration.service.InternalConfigurations;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.migration.persistence.legacy.PublishPayloadLocalPersistence_4_4;
import com.hivemq.migration.persistence.legacy.serializer.PublishPayloadRocksDBSerializer_4_4;
import com.hivemq.persistence.PersistenceStartup;
import com.hivemq.persistence.local.rocksdb.RocksDBLocalPersistence;
import com.hivemq.persistence.payload.PublishPayloadRocksDBLocalPersistence;
import com.hivemq.util.LocalPersistenceFileUtil;
import javax.annotation.PostConstruct;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LazySingleton
public class PublishPayloadRocksDBLocalPersistence_4_4
extends RocksDBLocalPersistence
implements PublishPayloadLocalPersistence_4_4 {
    private static final Logger log = LoggerFactory.getLogger(PublishPayloadRocksDBLocalPersistence.class);
    public static final String PERSISTENCE_VERSION = "040000_R";

    @Inject
    public PublishPayloadRocksDBLocalPersistence_4_4(@NotNull LocalPersistenceFileUtil localPersistenceFileUtil, @NotNull PersistenceStartup persistenceStartup) {
        super(localPersistenceFileUtil, persistenceStartup, InternalConfigurations.PAYLOAD_PERSISTENCE_BUCKET_COUNT.get(), InternalConfigurations.PAYLOAD_PERSISTENCE_MEMTABLE_SIZE_PORTION.get(), InternalConfigurations.PAYLOAD_PERSISTENCE_BLOCK_CACHE_SIZE_PORTION.get(), 32768, false);
    }

    @Override
    @NotNull
    protected String getName() {
        return "publish_payload_store";
    }

    @Override
    @NotNull
    protected String getVersion() {
        return PERSISTENCE_VERSION;
    }

    @Override
    @NotNull
    protected Logger getLogger() {
        return log;
    }

    @Override
    @PostConstruct
    protected void postConstruct() {
        super.postConstruct();
    }

    @Override
    protected void init() {
    }

    @Override
    @Nullable
    public byte[] get(long id) {
        RocksDB bucket = this.getRocksDb(Long.toString(id));
        try {
            return bucket.get(PublishPayloadRocksDBSerializer_4_4.serializeKey(id));
        }
        catch (RocksDBException e) {
            log.error("Could not get a payload because of an exception: ", (Throwable)e);
            return null;
        }
    }

    @Override
    public void put(long id, @NotNull byte[] payload) {
        Preconditions.checkNotNull((Object)payload, (Object)"payload must not be null");
        RocksDB bucket = this.getRocksDb(Long.toString(id));
        try {
            bucket.put(PublishPayloadRocksDBSerializer_4_4.serializeKey(id), payload);
        }
        catch (RocksDBException e) {
            log.error("Could not put a payload because of an exception: ", (Throwable)e);
        }
    }
}

