/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.migration.persistence.legacy.serializer;

import com.google.common.base.Preconditions;
import com.hivemq.codec.encoder.mqtt5.Mqtt5PayloadFormatIndicator;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.mqtt.message.QoS;
import com.hivemq.mqtt.message.mqtt5.Mqtt5UserProperties;
import com.hivemq.mqtt.message.mqtt5.PropertiesSerializationUtil;
import com.hivemq.persistence.RetainedMessage;
import com.hivemq.util.Bytes;
import java.nio.charset.StandardCharsets;

public class RetainedMessageDeserializer_4_4 {
    @NotNull
    public static byte[] serializeKey(@NotNull String topic) {
        Preconditions.checkNotNull((Object)topic, (Object)"Topic must not be null");
        return topic.getBytes(StandardCharsets.UTF_8);
    }

    @NotNull
    public static byte[] serializeValue(RetainedMessage retainedMessage) {
        byte[] responseTopic = retainedMessage.getResponseTopic() == null ? null : retainedMessage.getResponseTopic().getBytes(StandardCharsets.UTF_8);
        byte[] contentType = retainedMessage.getContentType() == null ? null : retainedMessage.getContentType().getBytes(StandardCharsets.UTF_8);
        byte[] correlationData = retainedMessage.getCorrelationData();
        int responseTopicLength = responseTopic != null ? responseTopic.length : 0;
        int contentTypeLength = contentType != null ? contentType.length : 0;
        int correlationDataLength = correlationData != null ? correlationData.length : 0;
        int payloadFormatIndicator = retainedMessage.getPayloadFormatIndicator() != null ? retainedMessage.getPayloadFormatIndicator().getCode() : -1;
        int cursor = 0;
        byte[] bytes = new byte[25 + PropertiesSerializationUtil.encodedSize(retainedMessage.getUserProperties()) + responseTopicLength + 4 + contentTypeLength + 4 + correlationDataLength + 4 + 1];
        bytes[cursor] = (byte)retainedMessage.getQos().getQosNumber();
        Bytes.copyLongToByteArray(retainedMessage.getTimestamp(), bytes, ++cursor);
        Bytes.copyLongToByteArray(retainedMessage.getPublishId(), bytes, cursor += 8);
        Bytes.copyLongToByteArray(retainedMessage.getMessageExpiryInterval(), bytes, cursor += 8);
        Bytes.copyIntToByteArray(responseTopicLength, bytes, cursor += 8);
        cursor += 4;
        if (responseTopicLength != 0) {
            System.arraycopy(responseTopic, 0, bytes, cursor, responseTopic.length);
            cursor += responseTopicLength;
        }
        Bytes.copyIntToByteArray(contentTypeLength, bytes, cursor);
        cursor += 4;
        if (contentTypeLength != 0) {
            System.arraycopy(contentType, 0, bytes, cursor, contentType.length);
            cursor += contentTypeLength;
        }
        Bytes.copyIntToByteArray(correlationDataLength, bytes, cursor);
        cursor += 4;
        if (correlationDataLength != 0) {
            System.arraycopy(correlationData, 0, bytes, cursor, correlationData.length);
            cursor += correlationDataLength;
        }
        bytes[cursor] = (byte)payloadFormatIndicator;
        PropertiesSerializationUtil.write(retainedMessage.getUserProperties(), bytes, ++cursor);
        return bytes;
    }

    @NotNull
    public static String deserializeKey(@NotNull byte[] serialized) {
        Preconditions.checkNotNull((Object)serialized, (Object)"Byte array must not be null");
        return new String(serialized, 0, serialized.length, StandardCharsets.UTF_8);
    }

    @NotNull
    public static RetainedMessage deserializeValue(@NotNull @NotNull byte @NotNull [] serialized) {
        byte[] correlationData;
        String contentType;
        String responseTopic;
        Preconditions.checkNotNull((Object)serialized, (Object)"Byte array must not be null");
        QoS qoS = QoS.valueOf(serialized[0] & 3);
        int cursor = 1;
        long timestamp = Bytes.readLong(serialized, cursor);
        long publishId = Bytes.readLong(serialized, cursor += 8);
        long ttl = Bytes.readLong(serialized, cursor += 8);
        int responseTopicLength = Bytes.readInt(serialized, cursor += 8);
        cursor += 4;
        if (responseTopicLength == 0) {
            responseTopic = null;
        } else {
            responseTopic = new String(serialized, cursor, responseTopicLength, StandardCharsets.UTF_8);
            cursor += responseTopicLength;
        }
        int contentTypeLength = Bytes.readInt(serialized, cursor);
        cursor += 4;
        if (contentTypeLength == 0) {
            contentType = null;
        } else {
            contentType = new String(serialized, cursor, contentTypeLength, StandardCharsets.UTF_8);
            cursor += contentTypeLength;
        }
        int correlationDataLength = Bytes.readInt(serialized, cursor);
        cursor += 4;
        if (correlationDataLength == 0) {
            correlationData = null;
        } else {
            correlationData = new byte[correlationDataLength];
            System.arraycopy(serialized, cursor, correlationData, 0, correlationDataLength);
            cursor += correlationDataLength;
        }
        Mqtt5PayloadFormatIndicator payloadFormatIndicator = serialized[cursor] != -1 ? Mqtt5PayloadFormatIndicator.fromCode(serialized[cursor]) : null;
        Mqtt5UserProperties properties = PropertiesSerializationUtil.read(serialized, ++cursor);
        return new RetainedMessage(null, qoS, publishId, ttl, properties, responseTopic, contentType, correlationData, payloadFormatIndicator, timestamp);
    }
}

