/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.migration.persistence.payload;

import com.hivemq.configuration.info.SystemInformation;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.migration.TypeMigration;
import com.hivemq.migration.meta.MetaFileService;
import com.hivemq.migration.meta.MetaInformation;
import com.hivemq.migration.meta.PersistenceType;
import com.hivemq.persistence.payload.PublishPayloadLocalPersistence;
import com.hivemq.persistence.payload.PublishPayloadRocksDBLocalPersistence;
import com.hivemq.persistence.payload.PublishPayloadXodusLocalPersistence;
import com.hivemq.util.LocalPersistenceFileUtil;
import java.io.File;
import javax.inject.Inject;
import javax.inject.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublishPayloadTypeMigration
implements TypeMigration {
    private static final Logger log = LoggerFactory.getLogger(PublishPayloadTypeMigration.class);
    private static final Logger migrationLog = LoggerFactory.getLogger((String)"migrations");
    @NotNull
    private final SystemInformation systemInformation;
    @NotNull
    private final LocalPersistenceFileUtil localPersistenceFileUtil;
    @NotNull
    private final Provider<PublishPayloadRocksDBLocalPersistence> persistenceRocksDBProvider;
    @NotNull
    private final Provider<PublishPayloadXodusLocalPersistence> persistenceXodusProvider;

    @Inject
    public PublishPayloadTypeMigration(@NotNull SystemInformation systemInformation, @NotNull LocalPersistenceFileUtil localPersistenceFileUtil, @NotNull Provider<PublishPayloadRocksDBLocalPersistence> persistenceRocksDBProvider, @NotNull Provider<PublishPayloadXodusLocalPersistence> persistenceXodusProvider) {
        this.systemInformation = systemInformation;
        this.localPersistenceFileUtil = localPersistenceFileUtil;
        this.persistenceRocksDBProvider = persistenceRocksDBProvider;
        this.persistenceXodusProvider = persistenceXodusProvider;
    }

    @Override
    public void migrateToType(@NotNull PersistenceType persistenceType) {
        if (persistenceType.equals((Object)PersistenceType.FILE_NATIVE)) {
            this.migrateToRocksDB();
        } else if (persistenceType.equals((Object)PersistenceType.FILE)) {
            this.migrateToXodus();
        } else {
            throw new IllegalArgumentException("Unknown persistence type " + String.valueOf((Object)persistenceType) + " for publish payload migration");
        }
    }

    private void migrateToXodus() {
        File persistenceFolder = this.localPersistenceFileUtil.getVersionedLocalPersistenceFolder("publish_payload_store", "040500_R");
        File publishPayloadStore0 = new File(persistenceFolder, "publish_payload_store_0");
        if (!publishPayloadStore0.exists()) {
            migrationLog.info("No (old) persistence folder (publish_payload) present, skipping migration.");
            log.debug("No (old) persistence folder (publish_payload) present, skipping migration.");
            return;
        }
        PublishPayloadXodusLocalPersistence xodusPersistence = (PublishPayloadXodusLocalPersistence)this.persistenceXodusProvider.get();
        PublishPayloadRocksDBLocalPersistence rocksdbPersistence = (PublishPayloadRocksDBLocalPersistence)this.persistenceRocksDBProvider.get();
        this.migrateFromTo(rocksdbPersistence, xodusPersistence, PersistenceType.FILE);
    }

    private void migrateToRocksDB() {
        File persistenceFolder = this.localPersistenceFileUtil.getVersionedLocalPersistenceFolder("publish_payload_store", "040500");
        File publishPayloadStore0 = new File(persistenceFolder, "publish_payload_store_0");
        if (!publishPayloadStore0.exists()) {
            migrationLog.info("No (old) persistence folder (publish_payload) present, skipping migration.");
            log.debug("No (old) persistence folder (publish_payload) present, skipping migration.");
            return;
        }
        PublishPayloadXodusLocalPersistence xodusPersistence = (PublishPayloadXodusLocalPersistence)this.persistenceXodusProvider.get();
        PublishPayloadRocksDBLocalPersistence rocksdbPersistence = (PublishPayloadRocksDBLocalPersistence)this.persistenceRocksDBProvider.get();
        this.migrateFromTo(xodusPersistence, rocksdbPersistence, PersistenceType.FILE_NATIVE);
    }

    private void migrateFromTo(@NotNull PublishPayloadLocalPersistence from, @NotNull PublishPayloadLocalPersistence to, @NotNull PersistenceType persistenceType) {
        from.iterate((id, payload) -> {
            if (payload == null) {
                return;
            }
            to.put(id, payload);
        });
        this.savePersistenceType(persistenceType);
        to.init();
        from.closeDB();
    }

    private void savePersistenceType(@NotNull PersistenceType persistenceType) {
        MetaInformation metaFile = MetaFileService.readMetaFile(this.systemInformation);
        metaFile.setPublishPayloadPersistenceType(persistenceType);
        metaFile.setPublishPayloadPersistenceVersion(persistenceType == PersistenceType.FILE_NATIVE ? "040500_R" : "040500");
        MetaFileService.writeMetaFile(this.systemInformation, metaFile);
    }
}

