/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.migration.persistence.retained;

import com.google.common.annotations.VisibleForTesting;
import com.hivemq.configuration.info.SystemInformation;
import com.hivemq.configuration.service.InternalConfigurations;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.migration.TypeMigration;
import com.hivemq.migration.logging.PayloadExceptionLogging;
import com.hivemq.migration.meta.MetaFileService;
import com.hivemq.migration.meta.MetaInformation;
import com.hivemq.migration.meta.PersistenceType;
import com.hivemq.persistence.RetainedMessage;
import com.hivemq.persistence.local.xodus.RetainedMessageRocksDBLocalPersistence;
import com.hivemq.persistence.local.xodus.RetainedMessageXodusLocalPersistence;
import com.hivemq.persistence.local.xodus.bucket.BucketUtils;
import com.hivemq.persistence.payload.PublishPayloadLocalPersistence;
import com.hivemq.persistence.payload.PublishPayloadLocalPersistenceProvider;
import com.hivemq.persistence.retained.RetainedMessageLocalPersistence;
import com.hivemq.util.Exceptions;
import com.hivemq.util.LocalPersistenceFileUtil;
import java.io.File;
import javax.inject.Inject;
import javax.inject.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetainedMessageTypeMigration
implements TypeMigration {
    private static final Logger log = LoggerFactory.getLogger(RetainedMessageTypeMigration.class);
    private static final Logger migrationLog = LoggerFactory.getLogger((String)"migrations");
    private static final String FIRST_BUCKET_FOLDER = "retained_messages_0";
    @NotNull
    private final Provider<RetainedMessageXodusLocalPersistence> xodusLocalPersistenceProvider;
    @NotNull
    private final Provider<RetainedMessageRocksDBLocalPersistence> rocksDBLocalPersistenceProvider;
    @NotNull
    private final LocalPersistenceFileUtil localPersistenceFileUtil;
    @NotNull
    private final PublishPayloadLocalPersistenceProvider publishPayloadLocalPersistenceProvider;
    @NotNull
    private final SystemInformation systemInformation;
    @NotNull
    private final PayloadExceptionLogging payloadExceptionLogging;
    private final int bucketCount;

    @Inject
    public RetainedMessageTypeMigration(@NotNull LocalPersistenceFileUtil localPersistenceFileUtil, @NotNull Provider<RetainedMessageXodusLocalPersistence> xodusLocalPersistenceProvider, @NotNull Provider<RetainedMessageRocksDBLocalPersistence> rocksDBLocalPersistenceProvider, @NotNull PublishPayloadLocalPersistenceProvider publishPayloadLocalPersistenceProvider, @NotNull SystemInformation systemInformation, @NotNull PayloadExceptionLogging payloadExceptionLogging) {
        this.localPersistenceFileUtil = localPersistenceFileUtil;
        this.xodusLocalPersistenceProvider = xodusLocalPersistenceProvider;
        this.rocksDBLocalPersistenceProvider = rocksDBLocalPersistenceProvider;
        this.publishPayloadLocalPersistenceProvider = publishPayloadLocalPersistenceProvider;
        this.systemInformation = systemInformation;
        this.bucketCount = InternalConfigurations.PERSISTENCE_BUCKET_COUNT.get();
        this.payloadExceptionLogging = payloadExceptionLogging;
    }

    @Override
    public void migrateToType(@NotNull PersistenceType type) {
        if (type.equals((Object)PersistenceType.FILE_NATIVE)) {
            this.migrateToRocksDB();
        } else if (type.equals((Object)PersistenceType.FILE)) {
            this.migrateToXodus();
        } else {
            throw new IllegalArgumentException("Unknown persistence type " + String.valueOf((Object)type) + " for retained message migration");
        }
    }

    private void migrateToXodus() {
        File persistenceFolder = this.localPersistenceFileUtil.getVersionedLocalPersistenceFolder("retained_messages", "040500_R");
        if (this.oldFolderMissing(persistenceFolder)) {
            return;
        }
        RetainedMessageXodusLocalPersistence xodus = (RetainedMessageXodusLocalPersistence)this.xodusLocalPersistenceProvider.get();
        RetainedMessageRocksDBLocalPersistence rocks = (RetainedMessageRocksDBLocalPersistence)this.rocksDBLocalPersistenceProvider.get();
        PublishPayloadLocalPersistence publishPayloadLocalPersistence = this.publishPayloadLocalPersistenceProvider.get();
        rocks.iterate(new RetainedMessagePersistenceTypeSwitchCallback(this.bucketCount, publishPayloadLocalPersistence, xodus, this.payloadExceptionLogging));
        this.savePersistenceType(PersistenceType.FILE);
        for (int i = 0; i < InternalConfigurations.PERSISTENCE_BUCKET_COUNT.get(); ++i) {
            rocks.clear(i);
        }
        rocks.stop();
    }

    private void migrateToRocksDB() {
        File persistenceFolder = this.localPersistenceFileUtil.getVersionedLocalPersistenceFolder("retained_messages", "040500");
        if (this.oldFolderMissing(persistenceFolder)) {
            return;
        }
        RetainedMessageXodusLocalPersistence xodus = (RetainedMessageXodusLocalPersistence)this.xodusLocalPersistenceProvider.get();
        RetainedMessageRocksDBLocalPersistence rocks = (RetainedMessageRocksDBLocalPersistence)this.rocksDBLocalPersistenceProvider.get();
        PublishPayloadLocalPersistence publishPayloadLocalPersistence = this.publishPayloadLocalPersistenceProvider.get();
        xodus.iterate(new RetainedMessagePersistenceTypeSwitchCallback(this.bucketCount, publishPayloadLocalPersistence, rocks, this.payloadExceptionLogging));
        this.savePersistenceType(PersistenceType.FILE_NATIVE);
        for (int i = 0; i < InternalConfigurations.PERSISTENCE_BUCKET_COUNT.get(); ++i) {
            xodus.clear(i);
        }
        xodus.stop();
    }

    private boolean oldFolderMissing(@NotNull File persistenceFolder) {
        File oldPersistenceFolder = new File(persistenceFolder, FIRST_BUCKET_FOLDER);
        if (!oldPersistenceFolder.exists()) {
            migrationLog.info("No (old) persistence folder (retained_messages) present, skipping migration.");
            log.debug("No (old) persistence folder (retained_messages) present, skipping migration.");
            return true;
        }
        return false;
    }

    private void savePersistenceType(@NotNull PersistenceType persistenceType) {
        MetaInformation metaFile = MetaFileService.readMetaFile(this.systemInformation);
        metaFile.setRetainedMessagesPersistenceType(persistenceType);
        metaFile.setRetainedMessagesPersistenceVersion(persistenceType == PersistenceType.FILE_NATIVE ? "040500_R" : "040500");
        MetaFileService.writeMetaFile(this.systemInformation, metaFile);
    }

    @VisibleForTesting
    static class RetainedMessagePersistenceTypeSwitchCallback
    implements RetainedMessageLocalPersistence.ItemCallback {
        private final int bucketCount;
        @NotNull
        private final PublishPayloadLocalPersistence payloadLocalPersistence;
        @NotNull
        private final RetainedMessageLocalPersistence retainedMessageLocalPersistence;
        @NotNull
        private final PayloadExceptionLogging payloadExceptionLogging;

        RetainedMessagePersistenceTypeSwitchCallback(int bucketCount, @NotNull PublishPayloadLocalPersistence payloadLocalPersistence, @NotNull RetainedMessageLocalPersistence retainedMessageLocalPersistence, @NotNull PayloadExceptionLogging payloadExceptionLogging) {
            this.bucketCount = bucketCount;
            this.payloadLocalPersistence = payloadLocalPersistence;
            this.retainedMessageLocalPersistence = retainedMessageLocalPersistence;
            this.payloadExceptionLogging = payloadExceptionLogging;
        }

        @Override
        public void onItem(@NotNull String topic, @NotNull RetainedMessage message) {
            try {
                int bucketIndex = BucketUtils.getBucket(topic, this.bucketCount);
                byte[] bytes = this.payloadLocalPersistence.get(message.getPublishId());
                if (bytes == null) {
                    this.payloadExceptionLogging.addLogging(message.getPublishId(), true, topic);
                    return;
                }
                message.setMessage(bytes);
                this.retainedMessageLocalPersistence.put(message, topic, bucketIndex);
            }
            catch (Throwable throwable) {
                log.warn("Could not migrate retained message for topic {}, original exception: ", (Object)topic, (Object)throwable);
                Exceptions.rethrowError(throwable);
            }
        }
    }
}

