/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.mqtt.callback;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.ListenableFuture;
import com.hivemq.bootstrap.ClientConnection;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.mqtt.handler.publish.PublishStatus;
import com.hivemq.mqtt.message.pool.FreePacketIdRanges;
import com.hivemq.mqtt.message.publish.PUBLISH;
import com.hivemq.mqtt.services.PublishPollService;
import com.hivemq.persistence.util.FutureUtils;
import io.netty.channel.Channel;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublishStatusFutureCallback
implements FutureCallback<PublishStatus> {
    @NotNull
    private static final Logger log = LoggerFactory.getLogger(PublishStatusFutureCallback.class);
    @NotNull
    private final PublishPollService publishPollService;
    private final boolean sharedSubscription;
    @NotNull
    private final String queueId;
    @NotNull
    private final PUBLISH publish;
    @NotNull
    private final FreePacketIdRanges messageIDPool;
    private final int packetIdentifier;
    @NotNull
    private final Channel channel;
    @NotNull
    private final String client;

    public PublishStatusFutureCallback(@NotNull PublishPollService publishPollService, boolean sharedSubscription, @NotNull String queueId, @NotNull PUBLISH publish, @NotNull FreePacketIdRanges messageIDPool, @NotNull Channel channel, @NotNull String client) {
        this.publishPollService = publishPollService;
        this.sharedSubscription = sharedSubscription;
        this.queueId = queueId;
        this.publish = publish;
        this.packetIdentifier = publish.getPacketIdentifier();
        this.messageIDPool = messageIDPool;
        this.channel = channel;
        this.client = client;
    }

    public void onSuccess(PublishStatus status) {
        AtomicInteger inFlightMessages;
        try {
            if (status == PublishStatus.IN_PROGRESS) {
                log.error("'IN_PROGRESS' is not an expected publish status in the PublishStatusFutureCallback");
                return;
            }
            if (this.publish.getQoS().getQosNumber() > 0) {
                ListenableFuture<Void> future;
                if (this.sharedSubscription) {
                    if (status == PublishStatus.DELIVERED) {
                        future = this.publishPollService.removeMessageFromSharedQueue(this.queueId, this.publish.getUniqueId());
                        FutureUtils.addExceptionLogger(future);
                    } else if (status == PublishStatus.NOT_CONNECTED || status == PublishStatus.FAILED) {
                        future = this.publishPollService.removeInflightMarker(this.queueId, this.publish.getUniqueId());
                        FutureUtils.addExceptionLogger(future);
                    }
                } else if (status == PublishStatus.DELIVERED) {
                    future = this.publishPollService.removeMessageFromQueue(this.queueId, this.packetIdentifier);
                    FutureUtils.addExceptionLogger(future);
                }
            }
        }
        catch (Exception e) {
            log.error("Exceptions in publish status callback handling, queue ID = {}", (Object)this.queueId, (Object)e);
        }
        if (this.packetIdentifier != 0) {
            this.messageIDPool.returnId(this.packetIdentifier);
        }
        if (status != PublishStatus.NOT_CONNECTED && ((inFlightMessages = ClientConnection.of(this.channel).getInFlightMessageCount()) == null || inFlightMessages.decrementAndGet() <= 0)) {
            this.publishPollService.pollMessages(this.client, this.channel);
        }
    }

    public void onFailure(@NotNull Throwable throwable) {
    }
}

