/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.mqtt.handler.disconnect;

import com.google.common.base.Preconditions;
import com.hivemq.bootstrap.ClientConnectionContext;
import com.hivemq.bootstrap.ClientState;
import com.hivemq.configuration.service.InternalConfigurations;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.extension.sdk.api.packets.general.DisconnectedReasonCode;
import com.hivemq.extensions.events.OnAuthFailedEvent;
import com.hivemq.extensions.events.OnServerDisconnectEvent;
import com.hivemq.logging.EventLog;
import com.hivemq.mqtt.handler.disconnect.MqttServerDisconnector;
import com.hivemq.mqtt.message.ProtocolVersion;
import com.hivemq.mqtt.message.disconnect.DISCONNECT;
import com.hivemq.mqtt.message.mqtt5.Mqtt5UserProperties;
import com.hivemq.mqtt.message.reason.Mqtt5DisconnectReasonCode;
import com.hivemq.util.Checkpoints;
import com.hivemq.util.ThreadPreConditions;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class MqttServerDisconnectorImpl
implements MqttServerDisconnector {
    @NotNull
    private static final Logger log = LoggerFactory.getLogger(MqttServerDisconnectorImpl.class);
    private final boolean disconnectWithReasonCode;
    private final boolean disconnectWithReasonString;
    @NotNull
    private final EventLog eventLog;

    @Inject
    public MqttServerDisconnectorImpl(@NotNull EventLog eventLog) {
        this.eventLog = eventLog;
        this.disconnectWithReasonCode = InternalConfigurations.DISCONNECT_WITH_REASON_CODE_ENABLED.get();
        this.disconnectWithReasonString = InternalConfigurations.DISCONNECT_WITH_REASON_STRING_ENABLED.get();
    }

    @Override
    public void disconnect(@NotNull Channel channel, @Nullable String logMessage, @Nullable String eventLogMessage, @Nullable Mqtt5DisconnectReasonCode reasonCode, @Nullable String reasonString, @NotNull Mqtt5UserProperties userProperties, boolean isAuthentication, boolean forceClose) {
        Preconditions.checkNotNull((Object)channel, (Object)"Channel must never be null");
        ThreadPreConditions.inNettyChildEventloop();
        ClientConnectionContext clientConnectionContext = ClientConnectionContext.of(channel);
        ClientState oldClientState = clientConnectionContext.getClientState();
        clientConnectionContext.proposeClientState(ClientState.DISCONNECTING);
        Checkpoints.checkpoint("on-client-disconnect");
        if (!clientConnectionContext.getClientState().disconnected()) {
            this.log(clientConnectionContext, logMessage, eventLogMessage);
            this.fireEvents(clientConnectionContext, oldClientState, reasonCode, reasonString, userProperties, isAuthentication);
            MqttServerDisconnectorImpl.closeConnection(clientConnectionContext, this.disconnectWithReasonCode, this.disconnectWithReasonString, reasonCode, reasonString, userProperties, forceClose);
        }
    }

    private void fireEvents(@NotNull ClientConnectionContext clientConnectionContext, @NotNull ClientState oldClientState, @Nullable Mqtt5DisconnectReasonCode reasonCode, @Nullable String reasonString, @NotNull Mqtt5UserProperties userProperties, boolean isAuthentication) {
        if (oldClientState != ClientState.CONNECTING) {
            DisconnectedReasonCode disconnectedReasonCode = reasonCode == null ? null : reasonCode.toDisconnectedReasonCode();
            clientConnectionContext.getChannel().pipeline().fireUserEventTriggered(isAuthentication ? new OnAuthFailedEvent(disconnectedReasonCode, reasonString, userProperties) : new OnServerDisconnectEvent(disconnectedReasonCode, reasonString, userProperties));
        }
    }

    private void log(@NotNull ClientConnectionContext clientConnectionContext, @Nullable String logMessage, @Nullable String eventLogMessage) {
        if (log.isDebugEnabled() && logMessage != null && !logMessage.isEmpty()) {
            log.debug(logMessage, (Object)clientConnectionContext.getChannelIP().orElse("UNKNOWN"));
        }
        if (eventLogMessage != null && !eventLogMessage.isEmpty()) {
            this.eventLog.clientWasDisconnected(clientConnectionContext.getChannel(), eventLogMessage);
        }
    }

    private static void closeConnection(@NotNull ClientConnectionContext clientConnectionContext, boolean withReasonCode, boolean withReasonString, @Nullable Mqtt5DisconnectReasonCode reasonCode, @Nullable String reasonString, @NotNull Mqtt5UserProperties userProperties, boolean forceClose) {
        if (reasonCode == Mqtt5DisconnectReasonCode.SESSION_TAKEN_OVER) {
            clientConnectionContext.proposeClientState(ClientState.DISCONNECTED_TAKEN_OVER);
        } else {
            clientConnectionContext.proposeClientState(ClientState.DISCONNECTED_BY_SERVER);
        }
        if (forceClose) {
            clientConnectionContext.getChannel().close();
            return;
        }
        ProtocolVersion version = clientConnectionContext.getProtocolVersion();
        if (withReasonCode) {
            if (version == ProtocolVersion.MQTTv5) {
                Preconditions.checkNotNull((Object)reasonCode, (Object)"Reason code must never be null for Mqtt 5");
            }
            if (!withReasonString) {
                reasonString = null;
            }
        } else {
            reasonCode = null;
            reasonString = null;
        }
        if (reasonCode != null && version == ProtocolVersion.MQTTv5) {
            DISCONNECT disconnect = new DISCONNECT(reasonCode, reasonString, userProperties, null, Long.MAX_VALUE);
            clientConnectionContext.getChannel().writeAndFlush((Object)disconnect).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        } else {
            clientConnectionContext.getChannel().close();
        }
    }
}

