/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.mqtt.handler.ping;

import com.hivemq.bootstrap.ClientConnectionContext;
import com.hivemq.mqtt.message.PINGREQ;
import com.hivemq.mqtt.message.PINGRESP;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@ChannelHandler.Sharable
public class PingRequestHandler
extends SimpleChannelInboundHandler<PINGREQ> {
    private final Logger log = LoggerFactory.getLogger(PingRequestHandler.class);
    private static final PINGRESP PING_RESPONSE = new PINGRESP();

    @Inject
    PingRequestHandler() {
    }

    protected void channelRead0(ChannelHandlerContext ctx, PINGREQ msg) throws Exception {
        if (this.log.isTraceEnabled()) {
            this.log.trace("PingReq received for client {}.", (Object)ClientConnectionContext.of(ctx.channel()).getClientId());
        }
        ctx.writeAndFlush((Object)PING_RESPONSE);
        if (this.log.isTraceEnabled()) {
            this.log.trace("PingResp sent for client {}.", (Object)ClientConnectionContext.of(ctx.channel()).getClientId());
        }
    }
}

