/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.mqtt.handler.publish;

import com.google.common.util.concurrent.SettableFuture;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.mqtt.handler.publish.PublishStatus;
import com.hivemq.util.Exceptions;
import io.netty.handler.codec.EncoderException;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublishWriteFailedListener
implements GenericFutureListener<Future<? super Void>> {
    @NotNull
    private static final Logger log = LoggerFactory.getLogger(PublishWriteFailedListener.class);
    @NotNull
    private final SettableFuture<PublishStatus> statusFuture;

    public PublishWriteFailedListener(@NotNull SettableFuture<PublishStatus> statusFuture) {
        this.statusFuture = statusFuture;
    }

    public void operationComplete(Future<? super Void> future) throws Exception {
        if (!future.isSuccess()) {
            Throwable cause = future.cause();
            if (Exceptions.isConnectionClosedException(cause)) {
                log.trace("Failed to write publish. Client not connected anymore");
                this.statusFuture.set((Object)PublishStatus.NOT_CONNECTED);
            } else if (cause instanceof EncoderException) {
                Exceptions.rethrowError("Failed to write publish. Encoding Failure.", cause);
                Throwable rootCause = cause.getCause();
                if (cause != rootCause) {
                    Exceptions.rethrowError("Failed to write publish. Encoding Failure, root cause:", rootCause);
                }
                this.statusFuture.set((Object)PublishStatus.FAILED);
            } else {
                Exceptions.rethrowError("Failed to write publish.", cause);
                this.statusFuture.set((Object)PublishStatus.FAILED);
            }
        }
    }
}

