/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.mqtt.handler.subscribe.retained;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.hivemq.bootstrap.ClientConnection;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.mqtt.handler.subscribe.retained.RetainedMessagesSender;
import com.hivemq.mqtt.message.pool.exception.NoMessageIdAvailableException;
import com.hivemq.mqtt.message.subscribe.Topic;
import com.hivemq.util.Exceptions;
import io.netty.channel.Channel;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendRetainedMessageResultListener
implements FutureCallback<Void> {
    private static final Logger log = LoggerFactory.getLogger(SendRetainedMessageResultListener.class);
    @NotNull
    private final Channel channel;
    @NotNull
    private final Topic subscription;
    @NotNull
    private final RetainedMessagesSender retainedMessagesSender;

    SendRetainedMessageResultListener(@NotNull Channel channel, @NotNull Topic subscription, @NotNull RetainedMessagesSender retainedMessagesSender) {
        this.channel = channel;
        this.subscription = subscription;
        this.retainedMessagesSender = retainedMessagesSender;
    }

    public void onSuccess(@Nullable Void aVoid) {
    }

    public void onFailure(@NotNull Throwable throwable) {
        if (Exceptions.isConnectionClosedException(throwable)) {
            return;
        }
        if (throwable instanceof NoMessageIdAvailableException) {
            if (!this.channel.isActive()) {
                return;
            }
            this.channel.eventLoop().schedule(() -> {
                if (log.isTraceEnabled()) {
                    log.trace("Retrying retained message for client '{}' on topic '{}'.", (Object)ClientConnection.of(this.channel).getClientId(), (Object)this.subscription.getTopic());
                }
                ListenableFuture<Void> sentFuture = this.retainedMessagesSender.writeRetainedMessages(this.channel, this.subscription);
                Futures.addCallback(sentFuture, (FutureCallback)this, (Executor)this.channel.eventLoop());
            }, 1L, TimeUnit.SECONDS);
        } else {
            Exceptions.rethrowError("Unable to send retained message on topic " + this.subscription.getTopic() + " to client " + ClientConnection.of(this.channel).getClientId() + ".", throwable);
        }
    }
}

