/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.mqtt.message;

import com.hivemq.extension.sdk.api.annotations.NotNull;

public enum MessageType {
    RESERVED_ZERO(0),
    CONNECT(1),
    CONNACK(2),
    PUBLISH(3),
    PUBACK(4),
    PUBREC(5),
    PUBREL(6),
    PUBCOMP(7),
    SUBSCRIBE(8),
    SUBACK(9),
    UNSUBSCRIBE(10),
    UNSUBACK(11),
    PINGREQ(12),
    PINGRESP(13),
    DISCONNECT(14),
    AUTH(15);

    @NotNull
    private static final @NotNull MessageType @NotNull [] VALUES;
    private final int type;

    private MessageType(int type) {
        this.type = type;
    }

    @NotNull
    public static MessageType valueOf(int i) {
        try {
            return VALUES[i];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Invalid Message Type: " + i, e);
        }
    }

    public int getType() {
        return this.type;
    }

    static {
        VALUES = MessageType.values();
    }
}

