/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.mqtt.message.connack;

import com.google.common.base.Preconditions;
import com.hivemq.codec.encoder.mqtt5.UnsignedDataTypes;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.mqtt.message.QoS;
import com.hivemq.mqtt.message.connack.CONNACK;
import com.hivemq.mqtt.message.connack.Mqtt3ConnAckReturnCode;
import com.hivemq.mqtt.message.mqtt5.Mqtt5UserProperties;
import com.hivemq.mqtt.message.reason.Mqtt5ConnAckReasonCode;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public class CONNACKBuilder {
    @Nullable
    private Mqtt5ConnAckReasonCode mqtt5ConnAckReasonCode;
    @Nullable
    private Mqtt3ConnAckReturnCode mqtt3ConnAckReturnCode;
    @Nullable
    private String reasonString;
    @Nullable
    private Mqtt5UserProperties userProperties;
    private boolean sessionPresent;
    private long sessionExpiryInterval = Long.MAX_VALUE;
    private int serverKeepAlive = -1;
    @Nullable
    private String assignedClientIdentifier;
    @Nullable
    private String authMethod;
    private byte @Nullable [] authData;
    private int receiveMaximum = 65535;
    private int topicAliasMaximum = 0;
    private int maximumPacketSize = 0x10000004;
    @Nullable
    private QoS maximumQoS;
    private boolean isRetainAvailable = true;
    private boolean isWildcardSubscriptionAvailable = true;
    private boolean isSubscriptionIdentifierAvailable = true;
    private boolean isSharedSubscriptionAvailable = true;
    @Nullable
    private String responseInformation;
    @Nullable
    private String serverReference;

    CONNACKBuilder() {
    }

    @NotNull
    public CONNACK build() {
        Preconditions.checkArgument((this.receiveMaximum != 0 ? 1 : 0) != 0, (Object)"Receive maximum must never be zero");
        if (this.assignedClientIdentifier != null) {
            Preconditions.checkArgument((boolean)UnsignedDataTypes.isUnsignedShort(this.assignedClientIdentifier.getBytes(StandardCharsets.UTF_8).length), (Object)"A client Id must never exceed 65.535 bytes");
        }
        if (this.authMethod != null) {
            Preconditions.checkArgument((boolean)UnsignedDataTypes.isUnsignedShort(this.authMethod.getBytes(StandardCharsets.UTF_8).length), (Object)"An auth method must never exceed 65.535 bytes");
        }
        if (this.authData != null) {
            Preconditions.checkNotNull((Object)this.authMethod, (Object)"Auth method must be set if auth data is set");
            Preconditions.checkArgument((boolean)UnsignedDataTypes.isUnsignedShort(this.authData.length), (Object)"An auth data must never exceed 65.535 bytes");
        }
        if (this.responseInformation != null) {
            Preconditions.checkArgument((boolean)UnsignedDataTypes.isUnsignedShort(this.responseInformation.getBytes(StandardCharsets.UTF_8).length), (Object)"A response information must never exceed 65.535 bytes");
        }
        if (this.serverReference != null) {
            Preconditions.checkArgument((boolean)UnsignedDataTypes.isUnsignedShort(this.serverReference.getBytes(StandardCharsets.UTF_8).length), (Object)"A server reference must never exceed 65.535 bytes");
        }
        if (this.sessionExpiryInterval != Long.MAX_VALUE) {
            Preconditions.checkArgument((boolean)UnsignedDataTypes.isUnsignedInt(this.sessionExpiryInterval), (Object)"A session expiry interval must never be larger than 4.294.967.296");
        }
        Preconditions.checkArgument((this.maximumPacketSize <= 0x10000004 ? 1 : 0) != 0, (Object)"A maximum packet size must never be larger than 268.435.460");
        Preconditions.checkArgument((boolean)UnsignedDataTypes.isUnsignedShort(this.topicAliasMaximum), (Object)"A topic alias maximum must never be larger than 65.535");
        if (this.serverKeepAlive != -1) {
            Preconditions.checkArgument((boolean)UnsignedDataTypes.isUnsignedShort(this.serverKeepAlive), (Object)"A server keep alive must never be larger than 65.535");
        }
        if (this.mqtt3ConnAckReturnCode != null) {
            if (this.mqtt3ConnAckReturnCode != Mqtt3ConnAckReturnCode.ACCEPTED && this.sessionPresent) {
                throw new IllegalArgumentException("The sessionPresent flag is only allowed for return code " + String.valueOf((Object)Mqtt3ConnAckReturnCode.ACCEPTED));
            }
            this.mqtt5ConnAckReasonCode = Mqtt5ConnAckReasonCode.fromReturnCode(this.mqtt3ConnAckReturnCode);
        }
        Preconditions.checkNotNull((Object)this.mqtt5ConnAckReasonCode);
        return new CONNACK(this.mqtt5ConnAckReasonCode, this.reasonString, Objects.requireNonNullElse(this.userProperties, Mqtt5UserProperties.NO_USER_PROPERTIES), this.sessionPresent, this.sessionExpiryInterval, this.serverKeepAlive, this.assignedClientIdentifier, this.authMethod, this.authData, this.receiveMaximum, this.topicAliasMaximum, this.maximumPacketSize, this.maximumQoS, this.isRetainAvailable, this.isWildcardSubscriptionAvailable, this.isSubscriptionIdentifierAvailable, this.isSharedSubscriptionAvailable, this.responseInformation, this.serverReference);
    }

    @NotNull
    private CONNACKBuilder self() {
        return this;
    }

    @NotNull
    public CONNACKBuilder withReasonCode(@Nullable Mqtt5ConnAckReasonCode mqtt5ConnAckReasonCode) {
        this.mqtt5ConnAckReasonCode = mqtt5ConnAckReasonCode;
        return this.self();
    }

    @NotNull
    public CONNACKBuilder withMqtt3ReturnCode(@Nullable Mqtt3ConnAckReturnCode mqtt3ConnAckReturnCode) {
        this.mqtt3ConnAckReturnCode = mqtt3ConnAckReturnCode;
        return this.self();
    }

    @NotNull
    public CONNACKBuilder withReasonString(@Nullable String reasonString) {
        this.reasonString = reasonString;
        return this.self();
    }

    @NotNull
    public CONNACKBuilder withUserProperties(@Nullable Mqtt5UserProperties userProperties) {
        this.userProperties = userProperties;
        return this.self();
    }

    @NotNull
    public CONNACKBuilder withSessionPresent(boolean sessionPresent) {
        this.sessionPresent = sessionPresent;
        return this.self();
    }

    @NotNull
    public CONNACKBuilder withSessionExpiryInterval(long sessionExpiryInterval) {
        this.sessionExpiryInterval = sessionExpiryInterval;
        return this.self();
    }

    @NotNull
    public CONNACKBuilder withServerKeepAlive(int serverKeepAlive) {
        this.serverKeepAlive = serverKeepAlive;
        return this.self();
    }

    @NotNull
    public CONNACKBuilder withAssignedClientIdentifier(@Nullable String assignedClientIdentifier) {
        this.assignedClientIdentifier = assignedClientIdentifier;
        return this.self();
    }

    @NotNull
    public CONNACKBuilder withAuthMethod(@Nullable String authMethod) {
        this.authMethod = authMethod;
        return this.self();
    }

    @NotNull
    public CONNACKBuilder withAuthData(byte @Nullable [] authData) {
        this.authData = authData;
        return this.self();
    }

    @NotNull
    public CONNACKBuilder withReceiveMaximum(int receiveMaximum) {
        this.receiveMaximum = receiveMaximum;
        return this.self();
    }

    @NotNull
    public CONNACKBuilder withTopicAliasMaximum(int topicAliasMaximum) {
        this.topicAliasMaximum = topicAliasMaximum;
        return this.self();
    }

    @NotNull
    public CONNACKBuilder withMaximumPacketSize(int maximumPacketSize) {
        this.maximumPacketSize = maximumPacketSize;
        return this.self();
    }

    @NotNull
    public CONNACKBuilder withMaximumQoS(@Nullable QoS maximumQoS) {
        this.maximumQoS = maximumQoS;
        return this.self();
    }

    @NotNull
    public CONNACKBuilder withRetainAvailable(boolean retainAvailable) {
        this.isRetainAvailable = retainAvailable;
        return this.self();
    }

    @NotNull
    public CONNACKBuilder withWildcardSubscriptionAvailable(boolean wildcardSubscriptionAvailable) {
        this.isWildcardSubscriptionAvailable = wildcardSubscriptionAvailable;
        return this.self();
    }

    @NotNull
    public CONNACKBuilder withSubscriptionIdentifierAvailable(boolean subscriptionIdentifierAvailable) {
        this.isSubscriptionIdentifierAvailable = subscriptionIdentifierAvailable;
        return this.self();
    }

    @NotNull
    public CONNACKBuilder withSharedSubscriptionAvailable(boolean sharedSubscriptionAvailable) {
        this.isSharedSubscriptionAvailable = sharedSubscriptionAvailable;
        return this.self();
    }

    @NotNull
    public CONNACKBuilder withResponseInformation(@Nullable String responseInformation) {
        this.responseInformation = responseInformation;
        return this.self();
    }

    @NotNull
    public CONNACKBuilder withServerReference(@Nullable String serverReference) {
        this.serverReference = serverReference;
        return this.self();
    }
}

