/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.mqtt.message.connack;

import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.mqtt.message.Message;
import com.hivemq.mqtt.message.QoS;
import com.hivemq.mqtt.message.mqtt5.Mqtt5UserProperties;
import com.hivemq.mqtt.message.reason.Mqtt5ConnAckReasonCode;

public interface Mqtt5CONNACK
extends Message {
    public static final int DEFAULT_RECEIVE_MAXIMUM = 65535;
    public static final int DEFAULT_TOPIC_ALIAS_MAXIMUM = 0;
    public static final int DEFAULT_MAXIMUM_PACKET_SIZE_NO_LIMIT = 0x10000004;
    public static final QoS DEFAULT_MAXIMUM_QOS = QoS.EXACTLY_ONCE;
    public static final boolean DEFAULT_RETAIN_AVAILABLE = true;
    public static final boolean DEFAULT_WILDCARD_SUBSCRIPTION_AVAILABLE = true;
    public static final boolean DEFAULT_SUBSCRIPTION_IDENTIFIER_AVAILABLE = true;
    public static final boolean DEFAULT_SHARED_SUBSCRIPTION_AVAILABLE = true;

    public int getReceiveMaximum();

    public int getTopicAliasMaximum();

    public int getMaximumPacketSize();

    public QoS getMaximumQoS();

    public boolean isRetainAvailable();

    public boolean isWildcardSubscriptionAvailable();

    public boolean isSubscriptionIdentifierAvailable();

    public boolean isSharedSubscriptionAvailable();

    @NotNull
    public Mqtt5ConnAckReasonCode getReasonCode();

    public boolean isSessionPresent();

    public long getSessionExpiryInterval();

    public int getServerKeepAlive();

    @Nullable
    public String getAssignedClientIdentifier();

    @Nullable
    public String getAuthMethod();

    @Nullable
    public byte[] getAuthData();

    @Nullable
    public String getResponseInformation();

    @Nullable
    public String getServerReference();

    @Nullable
    public String getReasonString();

    @NotNull
    public Mqtt5UserProperties getUserProperties();
}

