/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.mqtt.message.connect;

import com.google.common.base.Preconditions;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.extensions.packets.connect.ConnectPacketImpl;
import com.hivemq.extensions.packets.general.MqttVersionUtil;
import com.hivemq.mqtt.message.MessageType;
import com.hivemq.mqtt.message.ProtocolVersion;
import com.hivemq.mqtt.message.connect.Mqtt3CONNECT;
import com.hivemq.mqtt.message.connect.Mqtt5CONNECT;
import com.hivemq.mqtt.message.connect.MqttWillPublish;
import com.hivemq.mqtt.message.mqtt5.Mqtt5UserProperties;
import com.hivemq.mqtt.message.mqtt5.MqttMessageWithUserProperties;
import com.hivemq.util.Bytes;
import java.nio.charset.StandardCharsets;

public class CONNECT
extends MqttMessageWithUserProperties
implements Mqtt5CONNECT,
Mqtt3CONNECT {
    @NotNull
    private final ProtocolVersion protocolVersion;
    @NotNull
    private final String clientIdentifier;
    private final int keepAlive;
    private final boolean cleanStart;
    private long sessionExpiryInterval;
    private int receiveMaximum;
    private int topicAliasMaximum;
    private long maximumPacketSize;
    private final boolean responseInformationRequested;
    private final boolean problemInformationRequested;
    @Nullable
    private final String username;
    private final byte @Nullable [] password;
    @Nullable
    private final String authMethod;
    private final byte @Nullable [] authData;
    @Nullable
    private final MqttWillPublish willPublish;

    private CONNECT(@NotNull ProtocolVersion protocolVersion, @NotNull String clientIdentifier, int keepAlive, boolean cleanStart, long sessionExpiryInterval, int receiveMaximum, int topicAliasMaximum, long maximumPacketSize, boolean responseInformationRequested, boolean problemInformationRequested, @Nullable String username, byte @Nullable [] password, @Nullable String authMethod, byte @Nullable [] authData, @Nullable MqttWillPublish willPublish, @NotNull Mqtt5UserProperties userProperties) {
        super(userProperties);
        this.protocolVersion = protocolVersion;
        this.clientIdentifier = clientIdentifier;
        this.keepAlive = keepAlive;
        this.cleanStart = cleanStart;
        this.sessionExpiryInterval = sessionExpiryInterval;
        this.receiveMaximum = receiveMaximum;
        this.topicAliasMaximum = topicAliasMaximum;
        this.maximumPacketSize = maximumPacketSize;
        this.responseInformationRequested = responseInformationRequested;
        this.problemInformationRequested = problemInformationRequested;
        this.username = username;
        this.password = password;
        this.authMethod = authMethod;
        this.authData = authData;
        this.willPublish = willPublish;
    }

    @Override
    @NotNull
    public ProtocolVersion getProtocolVersion() {
        return this.protocolVersion;
    }

    @Override
    @NotNull
    public String getClientIdentifier() {
        return this.clientIdentifier;
    }

    @Override
    public int getKeepAlive() {
        return this.keepAlive;
    }

    @Override
    public boolean isCleanStart() {
        return this.cleanStart;
    }

    @Override
    public long getSessionExpiryInterval() {
        return this.sessionExpiryInterval;
    }

    public void setSessionExpiryInterval(long sessionExpiryInterval) {
        this.sessionExpiryInterval = sessionExpiryInterval;
    }

    @Override
    public int getReceiveMaximum() {
        return this.receiveMaximum;
    }

    public void setReceiveMaximum(int receiveMaximum) {
        this.receiveMaximum = receiveMaximum;
    }

    @Override
    public int getTopicAliasMaximum() {
        return this.topicAliasMaximum;
    }

    public void setTopicAliasMaximum(int topicAliasMaximum) {
        this.topicAliasMaximum = topicAliasMaximum;
    }

    @Override
    public long getMaximumPacketSize() {
        return this.maximumPacketSize;
    }

    public void setMaximumPacketSize(long maximumPacketSize) {
        this.maximumPacketSize = maximumPacketSize;
    }

    @Override
    public boolean isResponseInformationRequested() {
        return this.responseInformationRequested;
    }

    @Override
    public boolean isProblemInformationRequested() {
        return this.problemInformationRequested;
    }

    @Override
    @Nullable
    public String getUsername() {
        return this.username;
    }

    @Override
    public byte @Nullable [] getPassword() {
        return this.password;
    }

    @Override
    @Nullable
    public String getPasswordAsUTF8String() {
        return this.password != null ? new String(this.password, StandardCharsets.UTF_8) : null;
    }

    @Override
    @Nullable
    public String getAuthMethod() {
        return this.authMethod;
    }

    @Override
    public byte @Nullable [] getAuthData() {
        return this.authData;
    }

    @Override
    @Nullable
    public MqttWillPublish getWillPublish() {
        return this.willPublish;
    }

    @Override
    @NotNull
    public MessageType getType() {
        return MessageType.CONNECT;
    }

    @NotNull
    public static CONNECT from(@NotNull ConnectPacketImpl packet, @NotNull String clusterId) {
        return new CONNECT(MqttVersionUtil.toProtocolVersion(packet.getMqttVersion()), packet.getClientId(), packet.getKeepAlive(), packet.getCleanStart(), packet.getSessionExpiryInterval(), packet.getReceiveMaximum(), packet.getTopicAliasMaximum(), packet.getMaximumPacketSize(), packet.getRequestResponseInformation(), packet.getRequestProblemInformation(), packet.getUserName().orElse(null), Bytes.getBytesFromReadOnlyBuffer(packet.getPassword()), packet.getAuthenticationMethod().orElse(null), Bytes.getBytesFromReadOnlyBuffer(packet.getAuthenticationData()), MqttWillPublish.fromWillPacket(clusterId, packet.getWillPublish().orElse(null)), Mqtt5UserProperties.of(packet.getUserProperties().asInternalList()));
    }

    public static class Mqtt5Builder {
        @Nullable
        private String clientIdentifier;
        private int keepAlive;
        private boolean cleanStart;
        private long sessionExpiryInterval;
        private int receiveMaximum;
        private int topicAliasMaximum;
        private long maximumPacketSize;
        private boolean responseInformationRequested = false;
        private boolean problemInformationRequested = true;
        @Nullable
        private String username;
        private byte @Nullable [] password;
        @Nullable
        private String authMethod;
        private byte @Nullable [] authData;
        @Nullable
        private MqttWillPublish willPublish;
        @NotNull
        private Mqtt5UserProperties userProperties = Mqtt5UserProperties.NO_USER_PROPERTIES;

        @NotNull
        public CONNECT build() {
            Preconditions.checkNotNull((Object)this.clientIdentifier, (Object)"client identifier must never be null");
            return new CONNECT(ProtocolVersion.MQTTv5, this.clientIdentifier, this.keepAlive, this.cleanStart, this.sessionExpiryInterval, this.receiveMaximum, this.topicAliasMaximum, this.maximumPacketSize, this.responseInformationRequested, this.problemInformationRequested, this.username, this.password, this.authMethod, this.authData, this.willPublish, this.userProperties);
        }

        @NotNull
        public Mqtt5Builder withClientIdentifier(@NotNull String clientIdentifier) {
            this.clientIdentifier = clientIdentifier;
            return this;
        }

        @NotNull
        public Mqtt5Builder withKeepAlive(int keepAlive) {
            this.keepAlive = keepAlive;
            return this;
        }

        @NotNull
        public Mqtt5Builder withCleanStart(boolean cleanStart) {
            this.cleanStart = cleanStart;
            return this;
        }

        @NotNull
        public Mqtt5Builder withSessionExpiryInterval(long sessionExpiryInterval) {
            this.sessionExpiryInterval = sessionExpiryInterval;
            return this;
        }

        @NotNull
        public Mqtt5Builder withReceiveMaximum(int receiveMaximum) {
            this.receiveMaximum = receiveMaximum;
            return this;
        }

        @NotNull
        public Mqtt5Builder withTopicAliasMaximum(int topicAliasMaximum) {
            this.topicAliasMaximum = topicAliasMaximum;
            return this;
        }

        @NotNull
        public Mqtt5Builder withMaximumPacketSize(long maximumPacketSize) {
            this.maximumPacketSize = maximumPacketSize;
            return this;
        }

        @NotNull
        public Mqtt5Builder withResponseInformationRequested(boolean responseInformationRequested) {
            this.responseInformationRequested = responseInformationRequested;
            return this;
        }

        @NotNull
        public Mqtt5Builder withProblemInformationRequested(boolean problemInformationRequested) {
            this.problemInformationRequested = problemInformationRequested;
            return this;
        }

        @NotNull
        public Mqtt5Builder withUsername(@Nullable String username) {
            this.username = username;
            return this;
        }

        @NotNull
        public Mqtt5Builder withPassword(byte @Nullable [] password) {
            this.password = password;
            return this;
        }

        @NotNull
        public Mqtt5Builder withAuthMethod(@Nullable String authMethod) {
            this.authMethod = authMethod;
            return this;
        }

        @NotNull
        public Mqtt5Builder withAuthData(byte @Nullable [] authData) {
            this.authData = authData;
            return this;
        }

        @NotNull
        public Mqtt5Builder withWillPublish(@Nullable MqttWillPublish willPublish) {
            this.willPublish = willPublish;
            return this;
        }

        @NotNull
        public Mqtt5Builder withUserProperties(@NotNull Mqtt5UserProperties userProperties) {
            this.userProperties = userProperties;
            return this;
        }
    }

    public static class Mqtt3Builder {
        @NotNull
        private ProtocolVersion protocolVersion = ProtocolVersion.MQTTv3_1_1;
        @Nullable
        private String clientIdentifier;
        private int keepAlive;
        private boolean cleanStart;
        private long sessionExpiryInterval;
        @Nullable
        private String username;
        private byte @Nullable [] password;
        @Nullable
        private MqttWillPublish willPublish;

        @NotNull
        public CONNECT build() {
            Preconditions.checkNotNull((Object)this.clientIdentifier, (Object)"client identifier must never be null");
            return new CONNECT(this.protocolVersion, this.clientIdentifier, this.keepAlive, this.cleanStart, this.sessionExpiryInterval, 65535, 0, 0x10000004L, false, true, this.username, this.password, null, null, this.willPublish, Mqtt5UserProperties.NO_USER_PROPERTIES);
        }

        @NotNull
        public Mqtt3Builder withProtocolVersion(@NotNull ProtocolVersion protocolVersion) {
            this.protocolVersion = protocolVersion;
            return this;
        }

        @NotNull
        public Mqtt3Builder withClientIdentifier(@NotNull String clientIdentifier) {
            this.clientIdentifier = clientIdentifier;
            return this;
        }

        @NotNull
        public Mqtt3Builder withKeepAlive(int keepAlive) {
            this.keepAlive = keepAlive;
            return this;
        }

        @NotNull
        public Mqtt3Builder withCleanStart(boolean cleanStart) {
            this.cleanStart = cleanStart;
            return this;
        }

        @NotNull
        public Mqtt3Builder withSessionExpiryInterval(long sessionExpiryInterval) {
            this.sessionExpiryInterval = sessionExpiryInterval;
            return this;
        }

        @NotNull
        public Mqtt3Builder withUsername(@Nullable String username) {
            this.username = username;
            return this;
        }

        @NotNull
        public Mqtt3Builder withPassword(byte @Nullable [] password) {
            this.password = password;
            return this;
        }

        @NotNull
        public Mqtt3Builder withWillPublish(@Nullable MqttWillPublish willPublish) {
            this.willPublish = willPublish;
            return this;
        }
    }
}

