/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.mqtt.message.connect;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.hivemq.codec.encoder.mqtt5.Mqtt5PayloadFormatIndicator;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.extension.sdk.api.packets.connect.WillPublishPacket;
import com.hivemq.extension.sdk.api.packets.general.UserProperty;
import com.hivemq.extension.sdk.api.packets.publish.PayloadFormatIndicator;
import com.hivemq.mqtt.message.QoS;
import com.hivemq.mqtt.message.mqtt5.Mqtt5UserProperties;
import com.hivemq.mqtt.message.mqtt5.MqttUserProperty;
import com.hivemq.persistence.Sizable;
import com.hivemq.util.Bytes;
import com.hivemq.util.ObjectMemoryEstimation;

public class MqttWillPublish
implements Sizable {
    public static final long WILL_DELAY_INTERVAL_NOT_SET = Long.MAX_VALUE;
    public static final long WILL_DELAY_INTERVAL_DEFAULT = 0L;
    private int sizeInMemory = -1;
    private final String topic;
    private byte[] payload;
    private final QoS qos;
    private final boolean retain;
    private final String hivemqId;
    private long messageExpiryInterval;
    private final Mqtt5PayloadFormatIndicator payloadFormatIndicator;
    private final String contentType;
    private final String responseTopic;
    private final byte[] correlationData;
    private final Mqtt5UserProperties userProperties;
    private long delayInterval;

    protected MqttWillPublish(@NotNull String hivemqId, @NotNull String topic, @Nullable byte[] payload, @NotNull QoS qos, boolean retain, long messageExpiryInterval, @Nullable Mqtt5PayloadFormatIndicator payloadFormatIndicator, @Nullable String contentType, @Nullable String responseTopic, @Nullable byte[] correlationData, @NotNull Mqtt5UserProperties userProperties, long delayInterval) {
        Preconditions.checkNotNull((Object)topic, (Object)"A topic must never be null");
        Preconditions.checkNotNull((Object)((Object)qos), (Object)"Quality of service must never be null");
        Preconditions.checkNotNull((Object)userProperties, (Object)"User properties must never be null");
        this.hivemqId = hivemqId;
        this.topic = topic;
        this.payload = payload;
        this.qos = qos;
        this.retain = retain;
        this.messageExpiryInterval = messageExpiryInterval;
        this.payloadFormatIndicator = payloadFormatIndicator;
        this.contentType = contentType;
        this.responseTopic = responseTopic;
        this.correlationData = correlationData;
        this.userProperties = userProperties;
        this.delayInterval = delayInterval;
    }

    protected MqttWillPublish(@NotNull String topic, @Nullable byte[] payload, @NotNull QoS qos, boolean retain, @NotNull String hivemqId) {
        Preconditions.checkNotNull((Object)topic, (Object)"A topic must never be null");
        Preconditions.checkNotNull((Object)((Object)qos), (Object)"Quality of service must never be null");
        this.topic = topic;
        this.payload = payload;
        this.qos = qos;
        this.retain = retain;
        this.hivemqId = hivemqId;
        this.contentType = null;
        this.responseTopic = null;
        this.correlationData = null;
        this.payloadFormatIndicator = Mqtt5PayloadFormatIndicator.UNSPECIFIED;
        this.userProperties = Mqtt5UserProperties.NO_USER_PROPERTIES;
        this.messageExpiryInterval = 0xFFFFFFFFL;
        this.delayInterval = 0L;
    }

    @Nullable
    public static MqttWillPublish fromWillPacket(@NotNull String hivemqId, @Nullable WillPublishPacket packet) {
        if (packet == null) {
            return null;
        }
        Mqtt5PayloadFormatIndicator payloadFormatIndicator = packet.getPayloadFormatIndicator().isPresent() ? Mqtt5PayloadFormatIndicator.valueOf(((PayloadFormatIndicator)packet.getPayloadFormatIndicator().get()).name()) : null;
        ImmutableList.Builder userProperties = new ImmutableList.Builder();
        for (UserProperty userProperty : packet.getUserProperties().asList()) {
            userProperties.add((Object)new MqttUserProperty(userProperty.getName(), userProperty.getValue()));
        }
        return new MqttWillPublish(hivemqId, packet.getTopic(), Bytes.getBytesFromReadOnlyBuffer(packet.getPayload()), QoS.valueOf(packet.getQos().getQosNumber()), packet.getRetain(), packet.getMessageExpiryInterval().orElse(Long.MAX_VALUE), payloadFormatIndicator, packet.getContentType().orElse(null), packet.getResponseTopic().orElse(null), Bytes.getBytesFromReadOnlyBuffer(packet.getCorrelationData()), Mqtt5UserProperties.of((ImmutableList<MqttUserProperty>)userProperties.build()), packet.getWillDelay());
    }

    public long getDelayInterval() {
        return this.delayInterval;
    }

    public String getHivemqId() {
        return this.hivemqId;
    }

    public String getTopic() {
        return this.topic;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public QoS getQos() {
        return this.qos;
    }

    public boolean isRetain() {
        return this.retain;
    }

    public long getMessageExpiryInterval() {
        return this.messageExpiryInterval;
    }

    public Mqtt5PayloadFormatIndicator getPayloadFormatIndicator() {
        return this.payloadFormatIndicator;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getResponseTopic() {
        return this.responseTopic;
    }

    public byte[] getCorrelationData() {
        return this.correlationData;
    }

    public Mqtt5UserProperties getUserProperties() {
        return this.userProperties;
    }

    public void setPayload(byte[] payload) {
        this.payload = payload;
    }

    public void setMessageExpiryInterval(long messageExpiryInterval) {
        this.messageExpiryInterval = messageExpiryInterval;
    }

    public void setDelayInterval(long delayInterval) {
        this.delayInterval = delayInterval;
    }

    @NotNull
    public MqttWillPublish deepCopy() {
        return new MqttWillPublish(this.hivemqId, this.topic, this.payload, this.qos, this.retain, this.messageExpiryInterval, this.payloadFormatIndicator, this.contentType, this.responseTopic, this.correlationData, this.userProperties, this.delayInterval);
    }

    @Override
    public int getEstimatedSize() {
        if (this.sizeInMemory != -1) {
            return this.sizeInMemory;
        }
        int size = 0;
        size += ObjectMemoryEstimation.objectShellSize();
        size += ObjectMemoryEstimation.intSize();
        size += ObjectMemoryEstimation.stringSize(this.topic);
        size += ObjectMemoryEstimation.byteArraySize(this.payload);
        size += ObjectMemoryEstimation.byteArraySize(this.correlationData);
        size += ObjectMemoryEstimation.stringSize(this.responseTopic);
        size += ObjectMemoryEstimation.stringSize(this.hivemqId);
        size += ObjectMemoryEstimation.stringSize(this.contentType);
        size += 24;
        for (MqttUserProperty userProperty : this.getUserProperties().asList()) {
            size += 24;
            size += ObjectMemoryEstimation.stringSize(userProperty.getName());
            size += ObjectMemoryEstimation.stringSize(userProperty.getValue());
        }
        size += ObjectMemoryEstimation.longSize();
        size += ObjectMemoryEstimation.enumSize();
        size += ObjectMemoryEstimation.enumSize();
        this.sizeInMemory = size += ObjectMemoryEstimation.longSize();
        return this.sizeInMemory;
    }

    public static class Mqtt5Builder {
        private String hivemqId;
        private String topic;
        private byte[] payload;
        private QoS qos;
        private boolean retain;
        private long messageExpiryInterval;
        private Mqtt5PayloadFormatIndicator payloadFormatIndicator;
        private String contentType;
        private String responseTopic;
        private byte[] correlationData;
        private Mqtt5UserProperties userProperties = Mqtt5UserProperties.NO_USER_PROPERTIES;
        private long delayInterval;

        public MqttWillPublish build() {
            return new MqttWillPublish(this.hivemqId, this.topic, this.payload, this.qos, this.retain, this.messageExpiryInterval, this.payloadFormatIndicator, this.contentType, this.responseTopic, this.correlationData, this.userProperties, this.delayInterval);
        }

        public Mqtt5Builder withHivemqId(String hivemqId) {
            this.hivemqId = hivemqId;
            return this;
        }

        public Mqtt5Builder withTopic(String topic) {
            this.topic = topic;
            return this;
        }

        public Mqtt5Builder withPayload(byte[] payload) {
            this.payload = payload;
            return this;
        }

        public Mqtt5Builder withQos(QoS qos) {
            this.qos = qos;
            return this;
        }

        public Mqtt5Builder withRetain(boolean retain) {
            this.retain = retain;
            return this;
        }

        public Mqtt5Builder withMessageExpiryInterval(long messageExpiryInterval) {
            this.messageExpiryInterval = messageExpiryInterval;
            return this;
        }

        public Mqtt5Builder withPayloadFormatIndicator(Mqtt5PayloadFormatIndicator payloadFormatIndicator) {
            this.payloadFormatIndicator = payloadFormatIndicator;
            return this;
        }

        public Mqtt5Builder withContentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public Mqtt5Builder withResponseTopic(String responseTopic) {
            this.responseTopic = responseTopic;
            return this;
        }

        public Mqtt5Builder withCorrelationData(byte[] correlationData) {
            this.correlationData = correlationData;
            return this;
        }

        public Mqtt5Builder withUserProperties(Mqtt5UserProperties userProperties) {
            this.userProperties = userProperties;
            return this;
        }

        public Mqtt5Builder withDelayInterval(long delayInterval) {
            this.delayInterval = delayInterval;
            return this;
        }
    }

    public static class Mqtt3Builder {
        private String topic;
        private byte[] payload;
        private QoS qos;
        private boolean retain;
        private String hivemqId;

        public MqttWillPublish build() {
            return new MqttWillPublish(this.topic, this.payload, this.qos, this.retain, this.hivemqId);
        }

        public Mqtt3Builder withTopic(String topic) {
            this.topic = topic;
            return this;
        }

        public Mqtt3Builder withPayload(byte[] payload) {
            this.payload = payload;
            return this;
        }

        public Mqtt3Builder withQos(QoS qos) {
            this.qos = qos;
            return this;
        }

        public Mqtt3Builder withRetain(boolean retain) {
            this.retain = retain;
            return this;
        }

        public Mqtt3Builder withHivemqId(String hivemqId) {
            this.hivemqId = hivemqId;
            return this;
        }
    }
}

