/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.mqtt.message.publish;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.ImmutableIntArray;
import com.hivemq.codec.encoder.mqtt5.Mqtt5PayloadFormatIndicator;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.mqtt.message.MessageType;
import com.hivemq.mqtt.message.QoS;
import com.hivemq.mqtt.message.mqtt5.Mqtt5UserProperties;
import com.hivemq.mqtt.message.mqtt5.MqttMessageWithUserProperties;
import com.hivemq.mqtt.message.mqtt5.MqttUserProperty;
import com.hivemq.mqtt.message.publish.Mqtt3PUBLISH;
import com.hivemq.mqtt.message.publish.Mqtt5PUBLISH;
import com.hivemq.util.ObjectMemoryEstimation;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;

public class PUBLISH
extends MqttMessageWithUserProperties
implements Mqtt3PUBLISH,
Mqtt5PUBLISH {
    public static final int DEFAULT_NO_TOPIC_ALIAS = -1;
    public static final int NO_PUBLISH_ID_SET = -1;
    private static final int SIZE_NOT_CALCULATED = -1;
    public static final long MESSAGE_EXPIRY_INTERVAL_NOT_SET = Long.MAX_VALUE;
    public static final long MESSAGE_EXPIRY_INTERVAL_MAX = 0xFFFFFFFFL;
    public static final AtomicLong PUBLISH_COUNTER = new AtomicLong(1L);
    protected long timestamp;
    private byte @Nullable [] payload;
    private boolean duplicateDelivery;
    @NotNull
    private final String topic;
    private final boolean retain;
    @NotNull
    private final QoS qos;
    @NotNull
    private final QoS onwardQos;
    private long messageExpiryInterval;
    private final long publishId;
    @NotNull
    private final String hivemqId;
    @NotNull
    private final String uniqueId;
    @Nullable
    private final Mqtt5PayloadFormatIndicator payloadFormatIndicator;
    @Nullable
    private final String contentType;
    @Nullable
    private final String responseTopic;
    private final byte @Nullable [] correlationData;
    private final boolean isNewTopicAlias;
    @Nullable
    private final ImmutableIntArray subscriptionIdentifiers;
    private int sizeInMemory = -1;

    PUBLISH(@NotNull String hivemqId, @NotNull String topic, byte @Nullable [] payload, @NotNull QoS qos, @NotNull QoS onwardQos, boolean retain, long messageExpiryInterval, @Nullable Mqtt5PayloadFormatIndicator payloadFormatIndicator, @Nullable String contentType, @Nullable String responseTopic, byte @Nullable [] correlationData, @NotNull Mqtt5UserProperties userProperties, int packetIdentifier, boolean duplicateDelivery, boolean isNewTopicAlias, @Nullable ImmutableIntArray subscriptionIdentifiers, long timestamp, long publishId) {
        super(userProperties);
        Preconditions.checkNotNull((Object)hivemqId, (Object)"HivemqId may never be null");
        Preconditions.checkNotNull((Object)topic, (Object)"Topic may never be null");
        Preconditions.checkNotNull((Object)((Object)qos), (Object)"Quality of service may never be null");
        this.topic = topic;
        this.payload = payload;
        this.qos = qos;
        this.onwardQos = onwardQos;
        this.retain = retain;
        this.duplicateDelivery = duplicateDelivery;
        this.isNewTopicAlias = isNewTopicAlias;
        this.subscriptionIdentifiers = subscriptionIdentifiers;
        this.messageExpiryInterval = messageExpiryInterval;
        this.payloadFormatIndicator = payloadFormatIndicator;
        this.contentType = contentType;
        this.responseTopic = responseTopic;
        this.correlationData = correlationData;
        this.publishId = publishId > -1L ? publishId : PUBLISH_COUNTER.getAndIncrement();
        this.hivemqId = hivemqId;
        this.uniqueId = hivemqId + "_pub_" + this.publishId;
        this.timestamp = timestamp > -1L ? timestamp : System.currentTimeMillis();
        this.setPacketIdentifier(packetIdentifier);
    }

    PUBLISH(@NotNull String hivemqId, @NotNull String topic, @Nullable byte[] payload, @NotNull QoS qos, @NotNull QoS onwardQos, boolean retain, long messageExpiryInterval, int packetIdentifier, boolean duplicateDelivery, long publishId, long timestamp) {
        super(Mqtt5UserProperties.NO_USER_PROPERTIES);
        Preconditions.checkNotNull((Object)hivemqId, (Object)"Hivemq Id may never be null");
        Preconditions.checkNotNull((Object)topic, (Object)"Topic may never be null");
        Preconditions.checkNotNull((Object)((Object)qos), (Object)"Quality of service may never be null");
        this.hivemqId = hivemqId;
        this.topic = topic;
        this.payload = payload;
        this.qos = qos;
        this.onwardQos = onwardQos;
        this.retain = retain;
        this.messageExpiryInterval = messageExpiryInterval;
        this.duplicateDelivery = duplicateDelivery;
        this.publishId = publishId > -1L ? publishId : PUBLISH_COUNTER.getAndIncrement();
        this.uniqueId = hivemqId + "_pub_" + this.publishId;
        this.timestamp = timestamp > -1L ? timestamp : System.currentTimeMillis();
        this.setPacketIdentifier(packetIdentifier);
        this.isNewTopicAlias = false;
        this.subscriptionIdentifiers = null;
        this.payloadFormatIndicator = null;
        this.contentType = null;
        this.responseTopic = null;
        this.correlationData = null;
    }

    public PUBLISH(@NotNull PUBLISH publish) {
        this(publish.getHivemqId(), publish.getTopic(), publish.getPayload(), publish.getQoS(), publish.getOnwardQoS(), publish.isRetain(), publish.getMessageExpiryInterval(), publish.getPayloadFormatIndicator(), publish.getContentType(), publish.getResponseTopic(), publish.getCorrelationData(), publish.getUserProperties(), publish.getPacketIdentifier(), publish.isDuplicateDelivery(), publish.isNewTopicAlias(), publish.getSubscriptionIdentifiers(), publish.getTimestamp(), publish.getPublishId());
    }

    @Override
    @NotNull
    public String getHivemqId() {
        return this.hivemqId;
    }

    @Override
    @NotNull
    public String getUniqueId() {
        return this.uniqueId;
    }

    @Override
    public long getPublishId() {
        return this.publishId;
    }

    @Override
    @Nullable
    public Mqtt5PayloadFormatIndicator getPayloadFormatIndicator() {
        return this.payloadFormatIndicator;
    }

    @Override
    @Nullable
    public String getContentType() {
        return this.contentType;
    }

    @Override
    @Nullable
    public String getResponseTopic() {
        return this.responseTopic;
    }

    @Override
    public byte @Nullable [] getCorrelationData() {
        return this.correlationData;
    }

    @Override
    public boolean isNewTopicAlias() {
        return this.isNewTopicAlias;
    }

    @Override
    public void setPayload(byte @Nullable [] payload) {
        this.payload = payload;
    }

    @Override
    public byte @Nullable [] getPayload() {
        return this.payload;
    }

    @Override
    @NotNull
    public String getTopic() {
        return this.topic;
    }

    @Override
    public boolean isDuplicateDelivery() {
        return this.duplicateDelivery;
    }

    public void setDuplicateDelivery(boolean duplicateDelivery) {
        this.duplicateDelivery = duplicateDelivery;
    }

    @Override
    public boolean isRetain() {
        return this.retain;
    }

    @Override
    @NotNull
    public QoS getQoS() {
        return this.qos;
    }

    @NotNull
    public QoS getOnwardQoS() {
        return this.onwardQos;
    }

    @Override
    public long getMessageExpiryInterval() {
        return this.messageExpiryInterval;
    }

    public void setMessageExpiryInterval(long messageExpiryInterval) {
        this.messageExpiryInterval = messageExpiryInterval;
    }

    @Override
    @Nullable
    public ImmutableIntArray getSubscriptionIdentifiers() {
        return this.subscriptionIdentifiers;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    public long getRemainingExpiry() {
        if (this.isExpiryDisabled()) {
            return Long.MAX_VALUE;
        }
        long waitingSeconds = (System.currentTimeMillis() - this.timestamp) / 1000L;
        return Math.max(0L, this.messageExpiryInterval - waitingSeconds);
    }

    public boolean isExpiryDisabled() {
        return this.messageExpiryInterval == -1L || this.messageExpiryInterval == Long.MAX_VALUE;
    }

    public boolean isExpired() {
        return this.getRemainingExpiry() == 0L;
    }

    @NotNull
    public String toString() {
        return "PUBLISH{uniqueId=" + this.uniqueId + ", timestamp=" + this.timestamp + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PUBLISH publish = (PUBLISH)o;
        return this.timestamp == publish.timestamp && this.duplicateDelivery == publish.duplicateDelivery && this.retain == publish.retain && this.messageExpiryInterval == publish.messageExpiryInterval && this.publishId == publish.publishId && this.isNewTopicAlias == publish.isNewTopicAlias && Arrays.equals(this.payload, publish.payload) && Objects.equals(this.topic, publish.topic) && this.qos == publish.qos && Objects.equals(this.hivemqId, publish.hivemqId) && Objects.equals(this.uniqueId, publish.uniqueId) && this.payloadFormatIndicator == publish.payloadFormatIndicator && Objects.equals(this.contentType, publish.contentType) && Objects.equals(this.responseTopic, publish.responseTopic) && Arrays.equals(this.correlationData, publish.correlationData) && Objects.equals(this.subscriptionIdentifiers, publish.subscriptionIdentifiers);
    }

    public int hashCode() {
        int result = Objects.hash(new Object[]{this.timestamp, this.topic, this.duplicateDelivery, this.retain, this.qos, this.messageExpiryInterval, this.publishId, this.hivemqId, this.uniqueId, this.payloadFormatIndicator, this.contentType, this.responseTopic, this.isNewTopicAlias, this.subscriptionIdentifiers});
        result = 31 * result + Arrays.hashCode(this.payload);
        result = 31 * result + Arrays.hashCode(this.correlationData);
        return result;
    }

    @Override
    @NotNull
    public MessageType getType() {
        return MessageType.PUBLISH;
    }

    public int getEstimatedSizeInMemory() {
        if (this.sizeInMemory != -1) {
            return this.sizeInMemory;
        }
        int size = 0;
        size += ObjectMemoryEstimation.objectShellSize();
        size += ObjectMemoryEstimation.intSize();
        size += ObjectMemoryEstimation.longSize();
        size += ObjectMemoryEstimation.stringSize(this.topic);
        size += ObjectMemoryEstimation.byteArraySize(this.payload);
        size += ObjectMemoryEstimation.byteArraySize(this.correlationData);
        size += ObjectMemoryEstimation.stringSize(this.responseTopic);
        size += ObjectMemoryEstimation.stringSize(this.uniqueId);
        size += ObjectMemoryEstimation.stringSize(this.hivemqId);
        size += ObjectMemoryEstimation.stringSize(this.contentType);
        size += 24;
        ImmutableList<MqttUserProperty> userProperties = this.getUserProperties().asList();
        for (int i = 0; i < userProperties.size(); ++i) {
            MqttUserProperty userProperty = (MqttUserProperty)userProperties.get(i);
            size += 24;
            size += ObjectMemoryEstimation.stringSize(userProperty.getName());
            size += ObjectMemoryEstimation.stringSize(userProperty.getValue());
        }
        size += ObjectMemoryEstimation.booleanSize();
        size += ObjectMemoryEstimation.booleanSize();
        size += ObjectMemoryEstimation.booleanSize();
        size += ObjectMemoryEstimation.longSize();
        size += ObjectMemoryEstimation.longSize();
        size += ObjectMemoryEstimation.longWrapperSize();
        size += ObjectMemoryEstimation.enumSize();
        size += ObjectMemoryEstimation.enumSize();
        this.sizeInMemory = size += ObjectMemoryEstimation.immutableIntArraySize(this.subscriptionIdentifiers);
        return this.sizeInMemory;
    }
}

