/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.mqtt.message.pubrel;

import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.extensions.packets.pubrel.PubrelPacketImpl;
import com.hivemq.mqtt.message.MessageType;
import com.hivemq.mqtt.message.mqtt5.Mqtt5UserProperties;
import com.hivemq.mqtt.message.mqtt5.MqttMessageWithUserProperties;
import com.hivemq.mqtt.message.mqtt5.MqttUserProperty;
import com.hivemq.mqtt.message.pubrel.Mqtt3PUBREL;
import com.hivemq.mqtt.message.pubrel.Mqtt5PUBREL;
import com.hivemq.mqtt.message.reason.Mqtt5PubRelReasonCode;
import com.hivemq.util.ObjectMemoryEstimation;
import java.util.concurrent.TimeUnit;

public class PUBREL
extends MqttMessageWithUserProperties.MqttMessageWithIdAndReasonCode<Mqtt5PubRelReasonCode>
implements Mqtt3PUBREL,
Mqtt5PUBREL {
    private static final int SIZE_NOT_CALCULATED = -1;
    @Nullable
    private Long publishTimestamp;
    @Nullable
    private Long messageExpiryInterval;
    private int sizeInMemory = -1;

    public PUBREL(int packetIdentifier) {
        super(packetIdentifier, Mqtt5PubRelReasonCode.SUCCESS, null, Mqtt5UserProperties.NO_USER_PROPERTIES);
    }

    public PUBREL(int packetIdentifier, @Nullable Long publishTimestamp, @Nullable Long messageExpiryInterval) {
        super(packetIdentifier, Mqtt5PubRelReasonCode.SUCCESS, null, Mqtt5UserProperties.NO_USER_PROPERTIES);
        this.publishTimestamp = publishTimestamp;
        this.messageExpiryInterval = messageExpiryInterval;
    }

    public PUBREL(int packetIdentifier, @NotNull Mqtt5PubRelReasonCode reasonCode, @Nullable String reasonString, @NotNull Mqtt5UserProperties userProperties) {
        super(packetIdentifier, reasonCode, reasonString, userProperties);
    }

    public PUBREL(int packetIdentifier, @NotNull Mqtt5PubRelReasonCode reasonCode, @Nullable String reasonString, @NotNull Mqtt5UserProperties userProperties, @Nullable Long publishTimestamp, @Nullable Long messageExpiryInterval) {
        super(packetIdentifier, reasonCode, reasonString, userProperties);
        this.publishTimestamp = publishTimestamp;
        this.messageExpiryInterval = messageExpiryInterval;
    }

    @Override
    @NotNull
    public MessageType getType() {
        return MessageType.PUBREL;
    }

    @Nullable
    public Long getMessageExpiryInterval() {
        return this.messageExpiryInterval;
    }

    public void setMessageExpiryInterval(@Nullable Long expiryInterval) {
        this.messageExpiryInterval = expiryInterval;
    }

    @Nullable
    public Long getPublishTimestamp() {
        return this.publishTimestamp;
    }

    public void setPublishTimestamp(@Nullable Long publishTimestamp) {
        this.publishTimestamp = publishTimestamp;
    }

    public boolean isExpiryDisabled() {
        return this.messageExpiryInterval == -1L || this.messageExpiryInterval == Long.MAX_VALUE;
    }

    public boolean hasExpired(long maximalPubRelExpiry) {
        if (this.publishTimestamp == null || this.messageExpiryInterval == null) {
            return false;
        }
        if (this.messageExpiryInterval == -1L || this.messageExpiryInterval == Long.MAX_VALUE) {
            return false;
        }
        long waitingSeconds = TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - this.publishTimestamp);
        long actualMessageExpiry = Math.min(this.messageExpiryInterval, maximalPubRelExpiry);
        long remainingTime = actualMessageExpiry - waitingSeconds;
        return remainingTime < 1L;
    }

    @NotNull
    public static PUBREL from(@NotNull PubrelPacketImpl packet) {
        return new PUBREL(packet.getPacketIdentifier(), Mqtt5PubRelReasonCode.from(packet.getReasonCode()), (String)packet.getReasonString().orElse(null), Mqtt5UserProperties.of(packet.getUserProperties().asInternalList()));
    }

    public int getEstimatedSizeInMemory() {
        if (this.sizeInMemory != -1) {
            return this.sizeInMemory;
        }
        int size = 0;
        size += ObjectMemoryEstimation.objectShellSize();
        size += ObjectMemoryEstimation.intSize();
        size += ObjectMemoryEstimation.intSize();
        size += ObjectMemoryEstimation.enumSize();
        size += ObjectMemoryEstimation.stringSize(this.getReasonString());
        size += ObjectMemoryEstimation.longWrapperSize();
        size += ObjectMemoryEstimation.longWrapperSize();
        size += 24;
        for (MqttUserProperty userProperty : this.getUserProperties().asList()) {
            size += 24;
            size += ObjectMemoryEstimation.stringSize(userProperty.getName());
            size += ObjectMemoryEstimation.stringSize(userProperty.getValue());
        }
        this.sizeInMemory = size;
        return this.sizeInMemory;
    }
}

