/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.mqtt.message.reason;

import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.extension.sdk.api.packets.auth.AuthReasonCode;
import com.hivemq.mqtt.message.reason.Mqtt5ReasonCode;
import com.hivemq.mqtt.message.reason.MqttCommonReasonCode;

public enum Mqtt5AuthReasonCode implements Mqtt5ReasonCode
{
    SUCCESS(MqttCommonReasonCode.SUCCESS),
    CONTINUE_AUTHENTICATION(24),
    REAUTHENTICATE(25);

    private final int code;
    @NotNull
    private final AuthReasonCode authReasonCode;
    @NotNull
    private static final @NotNull Mqtt5AuthReasonCode @NotNull [] AUTH_LOOKUP;

    private Mqtt5AuthReasonCode(int code) {
        this.code = code;
        this.authReasonCode = AuthReasonCode.valueOf((String)this.name());
    }

    private Mqtt5AuthReasonCode(MqttCommonReasonCode reasonCode) {
        this(reasonCode.getCode());
    }

    @Override
    public int getCode() {
        return this.code;
    }

    @NotNull
    public AuthReasonCode toAuthReasonCode() {
        return this.authReasonCode;
    }

    @Nullable
    public static Mqtt5AuthReasonCode fromCode(int code) {
        if (code == Mqtt5AuthReasonCode.SUCCESS.code) {
            return SUCCESS;
        }
        if (code == Mqtt5AuthReasonCode.CONTINUE_AUTHENTICATION.code) {
            return CONTINUE_AUTHENTICATION;
        }
        if (code == Mqtt5AuthReasonCode.REAUTHENTICATE.code) {
            return REAUTHENTICATE;
        }
        return null;
    }

    @NotNull
    public static Mqtt5AuthReasonCode from(@NotNull AuthReasonCode reasonCode) {
        return AUTH_LOOKUP[reasonCode.ordinal()];
    }

    @Override
    public boolean canBeSentByServer() {
        return this != REAUTHENTICATE;
    }

    @Override
    public boolean canBeSentByClient() {
        return this != SUCCESS;
    }

    static {
        AUTH_LOOKUP = new Mqtt5AuthReasonCode[AuthReasonCode.values().length];
        Mqtt5AuthReasonCode[] mqtt5AuthReasonCodeArray = Mqtt5AuthReasonCode.values();
        int n = mqtt5AuthReasonCodeArray.length;
        for (int i = 0; i < n; ++i) {
            Mqtt5AuthReasonCode reasonCode;
            Mqtt5AuthReasonCode.AUTH_LOOKUP[reasonCode.authReasonCode.ordinal()] = reasonCode = mqtt5AuthReasonCodeArray[i];
        }
    }
}

