/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.mqtt.message.reason;

import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.extension.sdk.api.packets.connect.ConnackReasonCode;
import com.hivemq.extension.sdk.api.packets.disconnect.DisconnectReasonCode;
import com.hivemq.extension.sdk.api.packets.general.DisconnectedReasonCode;
import com.hivemq.extension.sdk.api.packets.publish.AckReasonCode;
import com.hivemq.mqtt.message.connack.Mqtt3ConnAckReturnCode;
import com.hivemq.mqtt.message.reason.Mqtt5ReasonCode;
import com.hivemq.mqtt.message.reason.MqttCommonReasonCode;

public enum Mqtt5ConnAckReasonCode implements Mqtt5ReasonCode
{
    SUCCESS(MqttCommonReasonCode.SUCCESS),
    UNSPECIFIED_ERROR(MqttCommonReasonCode.UNSPECIFIED_ERROR),
    MALFORMED_PACKET(MqttCommonReasonCode.MALFORMED_PACKET),
    PROTOCOL_ERROR(MqttCommonReasonCode.PROTOCOL_ERROR),
    IMPLEMENTATION_SPECIFIC_ERROR(MqttCommonReasonCode.IMPLEMENTATION_SPECIFIC_ERROR),
    UNSUPPORTED_PROTOCOL_VERSION(132),
    CLIENT_IDENTIFIER_NOT_VALID(133),
    BAD_USER_NAME_OR_PASSWORD(134),
    NOT_AUTHORIZED(MqttCommonReasonCode.NOT_AUTHORIZED),
    SERVER_UNAVAILABLE(136),
    SERVER_BUSY(MqttCommonReasonCode.SERVER_BUSY),
    BANNED(138),
    BAD_AUTHENTICATION_METHOD(MqttCommonReasonCode.BAD_AUTHENTICATION_METHOD),
    TOPIC_NAME_INVALID(MqttCommonReasonCode.TOPIC_NAME_INVALID),
    PACKET_TOO_LARGE(MqttCommonReasonCode.PACKET_TOO_LARGE),
    QUOTA_EXCEEDED(MqttCommonReasonCode.QUOTA_EXCEEDED),
    PAYLOAD_FORMAT_INVALID(MqttCommonReasonCode.PAYLOAD_FORMAT_INVALID),
    RETAIN_NOT_SUPPORTED(MqttCommonReasonCode.RETAIN_NOT_SUPPORTED),
    QOS_NOT_SUPPORTED(MqttCommonReasonCode.QOS_NOT_SUPPORTED),
    USE_ANOTHER_SERVER(MqttCommonReasonCode.USE_ANOTHER_SERVER),
    SERVER_MOVED(MqttCommonReasonCode.SERVER_MOVED),
    CONNECTION_RATE_EXCEEDED(MqttCommonReasonCode.CONNECTION_RATE_EXCEEDED);

    private final int code;
    @NotNull
    private final ConnackReasonCode connackReasonCode;
    @NotNull
    private final DisconnectedReasonCode disconnectedReasonCode;
    private static final int ERROR_CODE_MIN;
    private static final int ERROR_CODE_MAX;
    private static final @Nullable Mqtt5ConnAckReasonCode @NotNull [] ERROR_CODE_LOOKUP;
    @NotNull
    private static final @NotNull Mqtt5ConnAckReasonCode @NotNull [] CONNACK_LOOKUP;
    private static final @Nullable Mqtt5ConnAckReasonCode @NotNull [] DISCONNECTED_LOOKUP;

    private Mqtt5ConnAckReasonCode(int code) {
        this.code = code;
        this.connackReasonCode = ConnackReasonCode.valueOf((String)this.name());
        this.disconnectedReasonCode = DisconnectedReasonCode.valueOf((String)this.name());
    }

    private Mqtt5ConnAckReasonCode(MqttCommonReasonCode reasonCode) {
        this(reasonCode.getCode());
    }

    @Override
    public int getCode() {
        return this.code;
    }

    @NotNull
    public ConnackReasonCode toConnackReasonCode() {
        return this.connackReasonCode;
    }

    @NotNull
    public DisconnectedReasonCode toDisconnectedReasonCode() {
        return this.disconnectedReasonCode;
    }

    @Nullable
    public static Mqtt5ConnAckReasonCode fromCode(int code) {
        if (code == Mqtt5ConnAckReasonCode.SUCCESS.code) {
            return SUCCESS;
        }
        if (code < ERROR_CODE_MIN || code > ERROR_CODE_MAX) {
            return null;
        }
        return ERROR_CODE_LOOKUP[code - ERROR_CODE_MIN];
    }

    @NotNull
    public static Mqtt5ConnAckReasonCode from(@NotNull ConnackReasonCode reasonCode) {
        return CONNACK_LOOKUP[reasonCode.ordinal()];
    }

    @Nullable
    public static Mqtt5ConnAckReasonCode from(@NotNull DisconnectedReasonCode reasonCode) {
        return DISCONNECTED_LOOKUP[reasonCode.ordinal()];
    }

    @NotNull
    public static Mqtt5ConnAckReasonCode fromReturnCode(@NotNull Mqtt3ConnAckReturnCode returnCode) {
        switch (returnCode) {
            case ACCEPTED: {
                return SUCCESS;
            }
            case REFUSED_UNACCEPTABLE_PROTOCOL_VERSION: {
                return UNSUPPORTED_PROTOCOL_VERSION;
            }
            case REFUSED_IDENTIFIER_REJECTED: {
                return CLIENT_IDENTIFIER_NOT_VALID;
            }
            case REFUSED_SERVER_UNAVAILABLE: {
                return SERVER_UNAVAILABLE;
            }
            case REFUSED_BAD_USERNAME_OR_PASSWORD: {
                return BAD_USER_NAME_OR_PASSWORD;
            }
            case REFUSED_NOT_AUTHORIZED: {
                return NOT_AUTHORIZED;
            }
        }
        throw new IllegalStateException();
    }

    @NotNull
    public static Mqtt5ConnAckReasonCode fromDisconnectReasonCode(@NotNull DisconnectReasonCode disconnectReasonCode) {
        switch (disconnectReasonCode) {
            case NORMAL_DISCONNECTION: 
            case DISCONNECT_WITH_WILL_MESSAGE: 
            case KEEP_ALIVE_TIMEOUT: 
            case UNSPECIFIED_ERROR: 
            case SESSION_TAKEN_OVER: 
            case RECEIVE_MAXIMUM_EXCEEDED: 
            case TOPIC_ALIAS_INVALID: 
            case MESSAGE_RATE_TOO_HIGH: 
            case ADMINISTRATIVE_ACTION: 
            case SHARED_SUBSCRIPTION_NOT_SUPPORTED: 
            case MAXIMUM_CONNECT_TIME: 
            case SUBSCRIPTION_IDENTIFIERS_NOT_SUPPORTED: 
            case WILDCARD_SUBSCRIPTION_NOT_SUPPORTED: {
                return UNSPECIFIED_ERROR;
            }
            case MALFORMED_PACKET: {
                return MALFORMED_PACKET;
            }
            case PROTOCOL_ERROR: {
                return PROTOCOL_ERROR;
            }
            case IMPLEMENTATION_SPECIFIC_ERROR: {
                return IMPLEMENTATION_SPECIFIC_ERROR;
            }
            case NOT_AUTHORIZED: {
                return NOT_AUTHORIZED;
            }
            case SERVER_BUSY: {
                return SERVER_BUSY;
            }
            case SERVER_SHUTTING_DOWN: {
                return SERVER_UNAVAILABLE;
            }
            case BAD_AUTHENTICATION_METHOD: {
                return BAD_AUTHENTICATION_METHOD;
            }
            case CLIENT_IDENTIFIER_NOT_VALID: {
                return CLIENT_IDENTIFIER_NOT_VALID;
            }
            case TOPIC_FILTER_INVALID: 
            case TOPIC_NAME_INVALID: {
                return TOPIC_NAME_INVALID;
            }
            case PACKET_TOO_LARGE: {
                return PACKET_TOO_LARGE;
            }
            case QUOTA_EXCEEDED: {
                return QUOTA_EXCEEDED;
            }
            case PAYLOAD_FORMAT_INVALID: {
                return PAYLOAD_FORMAT_INVALID;
            }
            case RETAIN_NOT_SUPPORTED: {
                return RETAIN_NOT_SUPPORTED;
            }
            case QOS_NOT_SUPPORTED: {
                return QOS_NOT_SUPPORTED;
            }
            case USE_ANOTHER_SERVER: {
                return USE_ANOTHER_SERVER;
            }
            case SERVER_MOVED: {
                return SERVER_MOVED;
            }
            case CONNECTION_RATE_EXCEEDED: {
                return CONNECTION_RATE_EXCEEDED;
            }
        }
        return UNSPECIFIED_ERROR;
    }

    @NotNull
    public static Mqtt5ConnAckReasonCode fromAckReasonCode(@NotNull AckReasonCode ackReasonCode) {
        switch (ackReasonCode) {
            case SUCCESS: {
                return SUCCESS;
            }
            case NO_MATCHING_SUBSCRIBERS: 
            case PACKET_IDENTIFIER_IN_USE: 
            case UNSPECIFIED_ERROR: {
                return UNSPECIFIED_ERROR;
            }
            case IMPLEMENTATION_SPECIFIC_ERROR: {
                return IMPLEMENTATION_SPECIFIC_ERROR;
            }
            case NOT_AUTHORIZED: {
                return NOT_AUTHORIZED;
            }
            case TOPIC_NAME_INVALID: {
                return TOPIC_NAME_INVALID;
            }
            case QUOTA_EXCEEDED: {
                return QUOTA_EXCEEDED;
            }
            case PAYLOAD_FORMAT_INVALID: {
                return PAYLOAD_FORMAT_INVALID;
            }
        }
        return UNSPECIFIED_ERROR;
    }

    static {
        ERROR_CODE_MIN = Mqtt5ConnAckReasonCode.UNSPECIFIED_ERROR.code;
        ERROR_CODE_MAX = Mqtt5ConnAckReasonCode.CONNECTION_RATE_EXCEEDED.code;
        ERROR_CODE_LOOKUP = new Mqtt5ConnAckReasonCode[ERROR_CODE_MAX - ERROR_CODE_MIN + 1];
        CONNACK_LOOKUP = new Mqtt5ConnAckReasonCode[ConnackReasonCode.values().length];
        DISCONNECTED_LOOKUP = new Mqtt5ConnAckReasonCode[DisconnectedReasonCode.values().length];
        for (Mqtt5ConnAckReasonCode reasonCode : Mqtt5ConnAckReasonCode.values()) {
            if (reasonCode != SUCCESS) {
                Mqtt5ConnAckReasonCode.ERROR_CODE_LOOKUP[reasonCode.code - Mqtt5ConnAckReasonCode.ERROR_CODE_MIN] = reasonCode;
            }
            Mqtt5ConnAckReasonCode.CONNACK_LOOKUP[reasonCode.connackReasonCode.ordinal()] = reasonCode;
            Mqtt5ConnAckReasonCode.DISCONNECTED_LOOKUP[reasonCode.disconnectedReasonCode.ordinal()] = reasonCode;
        }
    }
}

