/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.mqtt.message.reason;

import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.extension.sdk.api.packets.pubcomp.PubcompReasonCode;
import com.hivemq.mqtt.message.reason.Mqtt5ReasonCode;
import com.hivemq.mqtt.message.reason.MqttCommonReasonCode;

public enum Mqtt5PubCompReasonCode implements Mqtt5ReasonCode
{
    SUCCESS(MqttCommonReasonCode.SUCCESS),
    PACKET_IDENTIFIER_NOT_FOUND(MqttCommonReasonCode.PACKET_IDENTIFIER_NOT_FOUND);

    private final int code;
    @NotNull
    private final PubcompReasonCode pubcompReasonCode;
    @NotNull
    private static final @NotNull Mqtt5PubCompReasonCode @NotNull [] PUBCOMP_LOOKUP;

    private Mqtt5PubCompReasonCode(int code) {
        this.code = code;
        this.pubcompReasonCode = PubcompReasonCode.valueOf((String)this.name());
    }

    private Mqtt5PubCompReasonCode(MqttCommonReasonCode reasonCode) {
        this(reasonCode.getCode());
    }

    @Override
    public int getCode() {
        return this.code;
    }

    @NotNull
    public PubcompReasonCode toPubcompReasonCode() {
        return this.pubcompReasonCode;
    }

    @Nullable
    public static Mqtt5PubCompReasonCode fromCode(int code) {
        if (code == Mqtt5PubCompReasonCode.SUCCESS.code) {
            return SUCCESS;
        }
        if (code == Mqtt5PubCompReasonCode.PACKET_IDENTIFIER_NOT_FOUND.code) {
            return PACKET_IDENTIFIER_NOT_FOUND;
        }
        return null;
    }

    @NotNull
    public static Mqtt5PubCompReasonCode from(@NotNull PubcompReasonCode reasonCode) {
        return PUBCOMP_LOOKUP[reasonCode.ordinal()];
    }

    @Override
    public boolean canBeSentByClient() {
        return true;
    }

    static {
        PUBCOMP_LOOKUP = new Mqtt5PubCompReasonCode[PubcompReasonCode.values().length];
        Mqtt5PubCompReasonCode[] mqtt5PubCompReasonCodeArray = Mqtt5PubCompReasonCode.values();
        int n = mqtt5PubCompReasonCodeArray.length;
        for (int i = 0; i < n; ++i) {
            Mqtt5PubCompReasonCode reasonCode;
            Mqtt5PubCompReasonCode.PUBCOMP_LOOKUP[reasonCode.pubcompReasonCode.ordinal()] = reasonCode = mqtt5PubCompReasonCodeArray[i];
        }
    }
}

