/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.mqtt.message.reason;

import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.extension.sdk.api.packets.subscribe.SubackReasonCode;
import com.hivemq.mqtt.message.reason.Mqtt5ReasonCode;
import com.hivemq.mqtt.message.reason.MqttCommonReasonCode;

public enum Mqtt5SubAckReasonCode implements Mqtt5ReasonCode
{
    GRANTED_QOS_0(0),
    GRANTED_QOS_1(1),
    GRANTED_QOS_2(2),
    UNSPECIFIED_ERROR(MqttCommonReasonCode.UNSPECIFIED_ERROR),
    IMPLEMENTATION_SPECIFIC_ERROR(MqttCommonReasonCode.IMPLEMENTATION_SPECIFIC_ERROR),
    NOT_AUTHORIZED(MqttCommonReasonCode.NOT_AUTHORIZED),
    TOPIC_FILTER_INVALID(MqttCommonReasonCode.TOPIC_FILTER_INVALID),
    PACKET_IDENTIFIER_IN_USE(MqttCommonReasonCode.PACKET_IDENTIFIER_IN_USE),
    QUOTA_EXCEEDED(MqttCommonReasonCode.QUOTA_EXCEEDED),
    SHARED_SUBSCRIPTION_NOT_SUPPORTED(MqttCommonReasonCode.SHARED_SUBSCRIPTION_NOT_SUPPORTED),
    SUBSCRIPTION_IDENTIFIERS_NOT_SUPPORTED(MqttCommonReasonCode.SUBSCRIPTION_IDENTIFIERS_NOT_SUPPORTED),
    WILDCARD_SUBSCRIPTION_NOT_SUPPORTED(MqttCommonReasonCode.WILDCARD_SUBSCRIPTION_NOT_SUPPORTED);

    @NotNull
    private static final Mqtt5SubAckReasonCode[] VALUES;
    private final int code;
    @NotNull
    private final SubackReasonCode subackReasonCode;
    @NotNull
    private static final @NotNull Mqtt5SubAckReasonCode @NotNull [] SUBACK_LOOKUP;

    private Mqtt5SubAckReasonCode(int code) {
        this.code = code;
        this.subackReasonCode = SubackReasonCode.valueOf((String)this.name());
    }

    private Mqtt5SubAckReasonCode(MqttCommonReasonCode reasonCode) {
        this(reasonCode.getCode());
    }

    @Override
    public int getCode() {
        return this.code;
    }

    @NotNull
    public SubackReasonCode toSubackReasonCode() {
        return this.subackReasonCode;
    }

    @Nullable
    public static Mqtt5SubAckReasonCode fromCode(int code) {
        for (Mqtt5SubAckReasonCode reasonCode : VALUES) {
            if (reasonCode.code != code) continue;
            return reasonCode;
        }
        return null;
    }

    @NotNull
    public static Mqtt5SubAckReasonCode from(@NotNull SubackReasonCode reasonCode) {
        return SUBACK_LOOKUP[reasonCode.ordinal()];
    }

    static {
        VALUES = Mqtt5SubAckReasonCode.values();
        SUBACK_LOOKUP = new Mqtt5SubAckReasonCode[SubackReasonCode.values().length];
        Mqtt5SubAckReasonCode[] mqtt5SubAckReasonCodeArray = Mqtt5SubAckReasonCode.values();
        int n = mqtt5SubAckReasonCodeArray.length;
        for (int i = 0; i < n; ++i) {
            Mqtt5SubAckReasonCode reasonCode;
            Mqtt5SubAckReasonCode.SUBACK_LOOKUP[reasonCode.subackReasonCode.ordinal()] = reasonCode = mqtt5SubAckReasonCodeArray[i];
        }
    }
}

