/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.mqtt.message.subscribe;

import com.google.common.base.Preconditions;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.extension.sdk.api.packets.subscribe.Subscription;
import com.hivemq.mqtt.message.QoS;
import com.hivemq.mqtt.message.mqtt5.Mqtt5RetainHandling;
import com.hivemq.mqtt.message.subscribe.Mqtt3Topic;
import com.hivemq.mqtt.message.subscribe.Mqtt5Topic;
import com.hivemq.persistence.Sizable;
import com.hivemq.util.ObjectMemoryEstimation;
import java.io.Serializable;
import java.util.Objects;

public class Topic
implements Serializable,
Comparable<Topic>,
Mqtt3Topic,
Mqtt5Topic,
Sizable {
    public static final QoS DEFAULT_QOS = QoS.AT_LEAST_ONCE;
    @NotNull
    private final String topic;
    @NotNull
    private QoS qoS;
    private final boolean noLocal;
    private final boolean retainAsPublished;
    @NotNull
    private final Mqtt5RetainHandling retainHandling;
    @Nullable
    private final Integer subscriptionIdentifier;
    private int sizeInMemory = -1;

    public Topic(@NotNull String topic, @NotNull QoS qoS, boolean noLocal, boolean retainAsPublished, @NotNull Mqtt5RetainHandling retainHandling, @Nullable Integer subscriptionIdentifier) {
        Preconditions.checkNotNull((Object)topic, (Object)"A Topic must not be null");
        Preconditions.checkNotNull((Object)((Object)qoS), (Object)"A QoS must not be null");
        Preconditions.checkNotNull((Object)((Object)retainHandling), (Object)"A RetainHandling must not be null");
        Preconditions.checkArgument((subscriptionIdentifier == null || subscriptionIdentifier >= 1 && subscriptionIdentifier <= 0xFFFFFFF ? 1 : 0) != 0, (Object)"Subscription identifier must be between 1 and 268_435_455");
        this.topic = topic;
        this.qoS = qoS;
        this.noLocal = noLocal;
        this.retainAsPublished = retainAsPublished;
        this.retainHandling = retainHandling;
        this.subscriptionIdentifier = subscriptionIdentifier;
    }

    public Topic(@NotNull String topic, @NotNull QoS qoS, boolean noLocal, boolean retainAsPublished) {
        this(topic, qoS, noLocal, retainAsPublished, DEFAULT_RETAIN_HANDLING, null);
    }

    public Topic(@NotNull String topic, @NotNull QoS qoS) {
        this(topic, qoS, false, false, DEFAULT_RETAIN_HANDLING, null);
    }

    public static Topic topicFromString(@NotNull String string) {
        return new Topic(string, DEFAULT_QOS);
    }

    @NotNull
    public static Topic topicFromSubscription(@NotNull Subscription subscription, @Nullable Integer subscriptionIdentifier) {
        return new Topic(subscription.getTopicFilter(), Objects.requireNonNull(QoS.valueOf(subscription.getQos().getQosNumber())), subscription.getNoLocal(), subscription.getRetainAsPublished(), Objects.requireNonNull(Mqtt5RetainHandling.fromCode(subscription.getRetainHandling().getCode())), subscriptionIdentifier);
    }

    @Override
    @NotNull
    public String getTopic() {
        return this.topic;
    }

    @Override
    @NotNull
    public QoS getQoS() {
        return this.qoS;
    }

    public void setQoS(@NotNull QoS qos) {
        Preconditions.checkNotNull((Object)((Object)qos), (Object)"QoS must not be null");
        this.qoS = qos;
    }

    @Override
    public boolean isNoLocal() {
        return this.noLocal;
    }

    @Override
    @NotNull
    public Mqtt5RetainHandling getRetainHandling() {
        return this.retainHandling;
    }

    @Override
    public boolean isRetainAsPublished() {
        return this.retainAsPublished;
    }

    @Nullable
    public Integer getSubscriptionIdentifier() {
        return this.subscriptionIdentifier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Topic topic1 = (Topic)o;
        return this.topic.equals(topic1.topic);
    }

    public int hashCode() {
        return this.topic.hashCode();
    }

    @NotNull
    public String toString() {
        return "Topic{topic='" + this.topic + "', qoS=" + String.valueOf((Object)this.qoS) + "}";
    }

    @Override
    public int compareTo(@NotNull Topic o) {
        return this.topic.compareTo(o.getTopic());
    }

    @Override
    public int getEstimatedSize() {
        if (this.sizeInMemory != -1) {
            return this.sizeInMemory;
        }
        int size = 0;
        size += ObjectMemoryEstimation.objectShellSize();
        size += ObjectMemoryEstimation.stringSize(this.topic);
        size += ObjectMemoryEstimation.enumSize();
        size += ObjectMemoryEstimation.booleanSize();
        size += ObjectMemoryEstimation.booleanSize();
        size += ObjectMemoryEstimation.enumSize();
        this.sizeInMemory = size += ObjectMemoryEstimation.intWrapperSize();
        return this.sizeInMemory;
    }
}

