/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.mqtt.message.unsubscribe;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extensions.packets.unsubscribe.UnsubscribePacketImpl;
import com.hivemq.mqtt.message.MessageType;
import com.hivemq.mqtt.message.mqtt5.Mqtt5UserProperties;
import com.hivemq.mqtt.message.mqtt5.MqttMessageWithUserProperties;
import com.hivemq.mqtt.message.unsubscribe.Mqtt3UNSUBSCRIBE;
import com.hivemq.mqtt.message.unsubscribe.Mqtt5UNSUBSCRIBE;
import java.util.List;

public class UNSUBSCRIBE
extends MqttMessageWithUserProperties
implements Mqtt3UNSUBSCRIBE,
Mqtt5UNSUBSCRIBE {
    private final ImmutableList<String> topics;

    public UNSUBSCRIBE(@NotNull ImmutableList<String> topics) {
        this(topics, 0);
    }

    public UNSUBSCRIBE(@NotNull ImmutableList<String> topics, int packetIdentifier) {
        this(topics, packetIdentifier, Mqtt5UserProperties.NO_USER_PROPERTIES);
    }

    public UNSUBSCRIBE(@NotNull List<String> topics, int packetIdentifier) {
        this((ImmutableList<String>)ImmutableList.copyOf(topics), packetIdentifier, Mqtt5UserProperties.NO_USER_PROPERTIES);
    }

    public UNSUBSCRIBE(@NotNull ImmutableList<String> topicFilters, int packetIdentifier, Mqtt5UserProperties userProperties) {
        super(userProperties);
        Preconditions.checkNotNull(topicFilters);
        Preconditions.checkArgument((!topicFilters.isEmpty() ? 1 : 0) != 0, (Object)"topics may never be empty");
        this.topics = topicFilters;
        this.setPacketIdentifier(packetIdentifier);
    }

    @NotNull
    public static UNSUBSCRIBE from(@NotNull UnsubscribePacketImpl packet) {
        return new UNSUBSCRIBE(packet.getTopicFilters(), packet.getPacketIdentifier(), Mqtt5UserProperties.of(packet.getUserProperties().asInternalList()));
    }

    @Override
    @NotNull
    public ImmutableList<String> getTopics() {
        return this.topics;
    }

    @Override
    @NotNull
    public MessageType getType() {
        return MessageType.UNSUBSCRIBE;
    }
}

