/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.mqtt.services;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.SettableFuture;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.mqtt.handler.publish.PublishStatus;
import com.hivemq.mqtt.message.publish.PUBLISH;
import com.hivemq.util.Exceptions;

public class StandardPublishCallback
implements FutureCallback<PublishStatus> {
    @NotNull
    private final String subscriber;
    @NotNull
    private final PUBLISH msg;
    @NotNull
    private final SettableFuture<Void> publishFinishedFuture;

    StandardPublishCallback(@NotNull String subscriber, @NotNull PUBLISH msg, @NotNull SettableFuture<Void> publishFinishedFuture) {
        this.subscriber = subscriber;
        this.msg = msg;
        this.publishFinishedFuture = publishFinishedFuture;
    }

    public void onSuccess(@Nullable PublishStatus response) {
        this.publishFinishedFuture.set(null);
    }

    public void onFailure(@NotNull Throwable throwable) {
        this.publishFinishedFuture.set(null);
        Exceptions.rethrowError("Unable to send message with id " + this.msg.getUniqueId() + " on topic " + this.msg.getTopic() + " to client " + this.subscriber, throwable);
    }
}

