/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.mqtt.topic;

import com.google.common.base.Preconditions;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.mqtt.topic.SubscriptionFlag;
import com.hivemq.util.Bytes;
import java.util.Objects;

public class SubscriberWithQoS
implements Comparable<SubscriberWithQoS> {
    @NotNull
    private final String subscriber;
    private final int qos;
    @Nullable
    private final String sharedName;
    @Nullable
    private final Integer subscriptionIdentifier;
    @Nullable
    private final String topicFilter;
    private byte flags;

    public SubscriberWithQoS(@NotNull String subscriber, int qos, byte flags, @Nullable Integer subscriptionIdentifier) {
        this(subscriber, qos, flags, null, subscriptionIdentifier, null);
    }

    public SubscriberWithQoS(@NotNull String subscriber, int qos, byte flags, @Nullable String sharedName, @Nullable Integer subscriptionIdentifier, @Nullable String topicFilter) {
        Preconditions.checkNotNull((Object)subscriber, (Object)"Subscriber must not be null");
        Preconditions.checkArgument((qos <= 2 && qos >= 0 ? 1 : 0) != 0, (Object)"Quality of Service level must be between 0 and 2");
        this.subscriber = subscriber;
        this.qos = qos;
        this.flags = flags;
        this.sharedName = sharedName;
        this.subscriptionIdentifier = subscriptionIdentifier;
        this.topicFilter = topicFilter;
    }

    @NotNull
    public String getSubscriber() {
        return this.subscriber;
    }

    public int getQos() {
        return this.qos;
    }

    public byte getFlags() {
        return this.flags;
    }

    public void addFlags(SubscriptionFlag ... subscriptionFlags) {
        for (SubscriptionFlag flag : subscriptionFlags) {
            this.flags = Bytes.setBit(this.flags, flag.getFlagIndex());
        }
    }

    public void removeFlags(SubscriptionFlag ... subscriptionFlags) {
        for (SubscriptionFlag flag : subscriptionFlags) {
            this.flags = Bytes.unsetBit(this.flags, flag.getFlagIndex());
        }
    }

    public boolean isSharedSubscription() {
        return Bytes.isBitSet(this.flags, SubscriptionFlag.SHARED_SUBSCRIPTION.getFlagIndex());
    }

    public boolean isRetainAsPublished() {
        return Bytes.isBitSet(this.flags, SubscriptionFlag.RETAIN_AS_PUBLISHED.getFlagIndex());
    }

    public boolean isNoLocal() {
        return Bytes.isBitSet(this.flags, SubscriptionFlag.NO_LOCAL.getFlagIndex());
    }

    @Nullable
    public String getSharedName() {
        return this.sharedName;
    }

    @Nullable
    public Integer getSubscriptionIdentifier() {
        return this.subscriptionIdentifier;
    }

    @Nullable
    public String getTopicFilter() {
        return this.topicFilter;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubscriberWithQoS that = (SubscriberWithQoS)o;
        return this.qos == that.qos && this.flags == that.flags && Objects.equals(this.subscriber, that.subscriber) && Objects.equals(this.sharedName, that.sharedName) && Objects.equals(this.subscriptionIdentifier, that.subscriptionIdentifier) && Objects.equals(this.topicFilter, that.topicFilter);
    }

    public int hashCode() {
        return Objects.hash(this.subscriber, this.qos, this.flags, this.sharedName, this.subscriptionIdentifier, this.topicFilter);
    }

    @Override
    public int compareTo(@Nullable SubscriberWithQoS o) {
        if (o == null) {
            return -1;
        }
        int subscriberCompare = this.subscriber.compareTo(o.getSubscriber());
        if (subscriberCompare == 0) {
            int qosCompare = Integer.compare(this.qos, o.getQos());
            if (qosCompare == 0 && this.subscriptionIdentifier != null && o.subscriptionIdentifier != null) {
                return Integer.compare(this.subscriptionIdentifier, o.subscriptionIdentifier);
            }
            return qosCompare;
        }
        return subscriberCompare;
    }

    @NotNull
    public String toString() {
        return "SubscriberWithQoS{subscriber='" + this.subscriber + "', qos=" + this.qos + "}";
    }
}

