/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.mqtt.topic;

import com.hivemq.util.Bytes;

public enum SubscriptionFlag {
    SHARED_SUBSCRIPTION(1),
    RETAIN_AS_PUBLISHED(2),
    NO_LOCAL(3);

    private final int flagIndex;

    private SubscriptionFlag(int flagIndex) {
        this.flagIndex = flagIndex;
    }

    public int getFlagIndex() {
        return this.flagIndex;
    }

    public static byte getDefaultFlags(boolean isSharedSubscription, boolean retainAsPublished, boolean noLocal) {
        byte flags = Bytes.setBit((byte)0, SHARED_SUBSCRIPTION.getFlagIndex(), isSharedSubscription);
        flags = Bytes.setBit(flags, RETAIN_AS_PUBLISHED.getFlagIndex(), retainAsPublished);
        return Bytes.setBit(flags, NO_LOCAL.getFlagIndex(), noLocal);
    }
}

