/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.mqtt.topic;

import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.mqtt.topic.InvalidTopicException;
import com.hivemq.mqtt.topic.TopicMatcher;
import org.apache.commons.lang3.StringUtils;

public class TokenizedTopicMatcher
implements TopicMatcher {
    @Override
    public boolean matches(@NotNull String topicSubscription, @NotNull String actualTopic) throws InvalidTopicException {
        if (StringUtils.containsAny((CharSequence)actualTopic, (CharSequence)"#+")) {
            throw new InvalidTopicException("The actual topic must not contain a wildcard character (# or +)");
        }
        String subscription = StringUtils.stripEnd((String)topicSubscription, (String)"/");
        String topic = actualTopic;
        if (topic.length() > 1) {
            topic = StringUtils.stripEnd((String)topic, (String)"/");
        }
        if (StringUtils.containsNone((CharSequence)topicSubscription, (String)"#+")) {
            return subscription.equals(topic);
        }
        if (actualTopic.startsWith("$") && !topicSubscription.startsWith("$")) {
            return false;
        }
        return TokenizedTopicMatcher.matchesWildcards(subscription, topic);
    }

    private static boolean matchesWildcards(String topicSubscription, String actualTopic) {
        if (topicSubscription.contains("#") && !StringUtils.endsWith((CharSequence)topicSubscription, (CharSequence)"/#") && topicSubscription.length() > 1) {
            return false;
        }
        String[] subscription = StringUtils.splitPreserveAllTokens((String)topicSubscription, (String)"/");
        String[] topic = StringUtils.splitPreserveAllTokens((String)actualTopic, (String)"/");
        int smallest = Math.min(subscription.length, topic.length);
        for (int i = 0; i < smallest; ++i) {
            String sub = subscription[i];
            String t = topic[i];
            if (sub.equals(t)) continue;
            if ("#".equals(sub)) {
                return true;
            }
            if ("+".equals(sub)) continue;
            return false;
        }
        return subscription.length == topic.length || subscription.length - topic.length == 1 && "#".equals(subscription[subscription.length - 1]);
    }
}

