/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.mqtt.topic.tree;

import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.mqtt.topic.tree.MatchingNodeSubscriptions;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

class TopicTreeNode {
    @NotNull
    private final String topicPart;
    @NotNull
    final MatchingNodeSubscriptions wildcardSubscriptions;
    @NotNull
    final MatchingNodeSubscriptions exactSubscriptions;
    @Nullable
    @Nullable TopicTreeNode @Nullable [] children;
    @Nullable
    Map<String, TopicTreeNode> childrenMap;

    TopicTreeNode(@NotNull String topicPart) {
        this.topicPart = topicPart;
        this.wildcardSubscriptions = new MatchingNodeSubscriptions();
        this.exactSubscriptions = new MatchingNodeSubscriptions();
    }

    @NotNull
    public TopicTreeNode addChildNodeIfAbsent(@NotNull String childNodeTopicPart, int indexMapCreationThreshold) {
        if (this.children != null) {
            if (this.children.length > indexMapCreationThreshold && this.childrenMap == null) {
                this.childrenMap = new HashMap<String, TopicTreeNode>(this.children.length + 1);
                TopicTreeNode existingNode = null;
                for (TopicTreeNode child : this.children) {
                    if (child == null) continue;
                    this.childrenMap.put(child.getTopicPart(), child);
                    if (!child.getTopicPart().equals(childNodeTopicPart)) continue;
                    existingNode = child;
                }
                this.children = null;
                if (existingNode != null) {
                    return existingNode;
                }
                TopicTreeNode childNode = new TopicTreeNode(childNodeTopicPart);
                this.childrenMap.put(childNode.getTopicPart(), childNode);
                return childNode;
            }
            for (TopicTreeNode child : this.children) {
                if (child == null || !child.getTopicPart().equals(childNodeTopicPart)) continue;
                return child;
            }
            TopicTreeNode childNode = new TopicTreeNode(childNodeTopicPart);
            int emptySlotIndex = Arrays.asList(this.children).indexOf(null);
            if (emptySlotIndex >= 0) {
                this.children[emptySlotIndex] = childNode;
            } else {
                TopicTreeNode[] newChildren = new TopicTreeNode[this.children.length + 1];
                System.arraycopy(this.children, 0, newChildren, 0, this.children.length);
                newChildren[newChildren.length - 1] = childNode;
                this.children = newChildren;
            }
            return childNode;
        }
        if (this.childrenMap != null) {
            return this.childrenMap.computeIfAbsent(childNodeTopicPart, TopicTreeNode::new);
        }
        TopicTreeNode childNode = new TopicTreeNode(childNodeTopicPart);
        this.children = new TopicTreeNode[]{childNode};
        return childNode;
    }

    public boolean isNodeEmpty() {
        boolean noChildrenPresent = this.children == null && this.childrenMap == null || this.children != null && TopicTreeNode.isEmptyArray(this.children) || this.childrenMap != null && this.childrenMap.isEmpty();
        return noChildrenPresent && this.exactSubscriptions.isEmpty() && this.wildcardSubscriptions.isEmpty();
    }

    @Nullable
    public @Nullable TopicTreeNode @Nullable [] getChildren() {
        return this.children;
    }

    @Nullable
    public Map<String, TopicTreeNode> getChildrenMap() {
        return this.childrenMap;
    }

    @NotNull
    public String getTopicPart() {
        return this.topicPart;
    }

    private static boolean isEmptyArray(@Nullable @Nullable TopicTreeNode @Nullable [] array) {
        if (array == null) {
            return true;
        }
        for (TopicTreeNode child : array) {
            if (child == null) continue;
            return false;
        }
        return true;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TopicTreeNode node = (TopicTreeNode)o;
        return this.topicPart.equals(node.topicPart);
    }

    public int hashCode() {
        return this.topicPart.hashCode();
    }

    @NotNull
    public String toString() {
        return this.topicPart;
    }
}

