/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.persistence;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import com.hivemq.configuration.service.InternalConfigurations;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.persistence.ProducerQueues;
import com.hivemq.persistence.SingleWriterService;
import com.hivemq.persistence.local.xodus.bucket.BucketUtils;
import com.hivemq.util.ThreadFactoryUtil;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.jctools.queues.MpscUnboundedArrayQueue;

public class InMemoryProducerQueues
implements ProducerQueues {
    private final int bucketsPerQueue;
    @NotNull
    private final AtomicBoolean shutdown = new AtomicBoolean(false);
    @Nullable
    private ListenableFuture<Void> closeFuture;
    private final int persistenceBucketCount;
    @NotNull
    public final @NotNull MpscUnboundedArrayQueue<Runnable> @NotNull [] queues;
    @NotNull
    public final @NotNull AtomicInteger @NotNull [] wips;
    private final long shutdownGracePeriod;
    private long shutdownStartTime = Long.MAX_VALUE;

    public InMemoryProducerQueues(int persistenceBucketCount, int amountOfQueues) {
        int i;
        this.persistenceBucketCount = persistenceBucketCount;
        this.bucketsPerQueue = persistenceBucketCount / amountOfQueues;
        this.shutdownGracePeriod = InternalConfigurations.PERSISTENCE_SHUTDOWN_GRACE_PERIOD_MSEC.get();
        ImmutableList.Builder counterBuilder = ImmutableList.builder();
        this.queues = new MpscUnboundedArrayQueue[amountOfQueues];
        this.wips = new AtomicInteger[amountOfQueues];
        for (i = 0; i < amountOfQueues; ++i) {
            this.queues[i] = new MpscUnboundedArrayQueue(32);
            this.wips[i] = new AtomicInteger();
        }
        for (i = 0; i < amountOfQueues; ++i) {
            counterBuilder.add((Object)new AtomicLong(0L));
        }
    }

    @VisibleForTesting
    @NotNull
    ImmutableList<Integer> createBucketIndexes(int queueIndex, int bucketsPerQueue) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = bucketsPerQueue * queueIndex; i < bucketsPerQueue * (queueIndex + 1); ++i) {
            builder.add((Object)i);
        }
        return builder.build();
    }

    @Override
    @NotNull
    public <R> ListenableFuture<R> submit(@NotNull String key, @NotNull SingleWriterService.Task<R> task) {
        return this.submitInternal(this.getBucket(key), task, false);
    }

    @Override
    @NotNull
    public <R> ListenableFuture<R> submit(int bucketIndex, @NotNull SingleWriterService.Task<R> task) {
        return this.submitInternal(bucketIndex, task, false);
    }

    @Nullable
    private <R> ListenableFuture<R> submitInternal(int bucketIndex, @NotNull SingleWriterService.Task<R> task, boolean ignoreShutdown) {
        if (!ignoreShutdown && this.shutdown.get() && System.currentTimeMillis() - this.shutdownStartTime > this.shutdownGracePeriod) {
            return SettableFuture.create();
        }
        int queueIndex = bucketIndex / this.bucketsPerQueue;
        SettableFuture resultFuture = SettableFuture.create();
        MpscUnboundedArrayQueue<Runnable> queue = this.queues[queueIndex];
        AtomicInteger wip = this.wips[queueIndex];
        queue.offer(() -> {
            try {
                Object result = task.doTask(bucketIndex);
                resultFuture.set(result);
            }
            catch (Throwable e) {
                resultFuture.setException(e);
            }
        });
        if (wip.getAndIncrement() == 0) {
            int missed = 1;
            while (true) {
                Runnable runnable;
                if ((runnable = (Runnable)queue.poll()) != null) {
                    runnable.run();
                    continue;
                }
                if ((missed = wip.addAndGet(-missed)) == 0) break;
            }
        }
        return resultFuture;
    }

    @NotNull
    public <R> List<ListenableFuture<R>> submitToAllBuckets(@NotNull SingleWriterService.Task<R> task, boolean parallel) {
        if (parallel) {
            return this.submitToAllBucketsParallel(task, false);
        }
        return this.submitToAllBucketsSequential(task);
    }

    @Override
    @NotNull
    public <R> List<ListenableFuture<R>> submitToAllBucketsParallel(@NotNull SingleWriterService.Task<R> task) {
        return this.submitToAllBucketsParallel(task, false);
    }

    @NotNull
    private <R> List<ListenableFuture<R>> submitToAllBucketsParallel(@NotNull SingleWriterService.Task<R> task, boolean ignoreShutdown) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int bucket = 0; bucket < this.persistenceBucketCount; ++bucket) {
            builder.add(this.submitInternal(bucket, task, ignoreShutdown));
        }
        return builder.build();
    }

    @Override
    @NotNull
    public <R> List<ListenableFuture<R>> submitToAllBucketsSequential(@NotNull SingleWriterService.Task<R> task) {
        ImmutableList.Builder builder = ImmutableList.builder();
        ListenableFuture previousFuture = Futures.immediateFuture(null);
        int bucket = 0;
        while (bucket < this.persistenceBucketCount) {
            int finalBucket = bucket++;
            SettableFuture future = SettableFuture.create();
            previousFuture.addListener(() -> future.setFuture(this.submit(finalBucket, task)), MoreExecutors.directExecutor());
            previousFuture = future;
            builder.add((Object)future);
        }
        return builder.build();
    }

    @Override
    public int getBucket(@NotNull String key) {
        return BucketUtils.getBucket(key, this.persistenceBucketCount);
    }

    @Override
    @NotNull
    public ListenableFuture<Void> shutdown(@Nullable SingleWriterService.Task<Void> finalTask) {
        if (this.shutdown.getAndSet(true)) {
            if (this.closeFuture != null) {
                return this.closeFuture;
            }
            return Futures.immediateFuture(null);
        }
        this.shutdownStartTime = System.currentTimeMillis();
        ThreadFactory threadFactory = ThreadFactoryUtil.create("persistence-shutdown-%d");
        final ListeningScheduledExecutorService executorService = MoreExecutors.listeningDecorator((ScheduledExecutorService)Executors.newSingleThreadScheduledExecutor(threadFactory));
        this.closeFuture = executorService.schedule(() -> {
            if (finalTask != null) {
                Futures.allAsList(this.submitToAllBucketsParallel(finalTask, true)).get();
            } else {
                Futures.allAsList(this.submitToAllBucketsParallel(bucketIndex -> null, true)).get();
            }
            return null;
        }, this.shutdownGracePeriod + 50L, TimeUnit.MILLISECONDS);
        Futures.addCallback(this.closeFuture, (FutureCallback)new FutureCallback<Void>(){

            public void onSuccess(@Nullable Void aVoid) {
                executorService.shutdown();
            }

            public void onFailure(@NotNull Throwable throwable) {
                executorService.shutdown();
            }
        }, (Executor)executorService);
        return this.closeFuture;
    }
}

