/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.persistence;

import com.google.common.annotations.VisibleForTesting;
import com.hivemq.configuration.service.InternalConfigurations;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.persistence.InMemoryProducerQueues;
import com.hivemq.persistence.ProducerQueues;
import com.hivemq.persistence.SingleWriterService;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemorySingleWriter
implements SingleWriterService {
    @NotNull
    private static final Logger log = LoggerFactory.getLogger(InMemorySingleWriter.class);
    private static final int AMOUNT_OF_PRODUCERS = 5;
    private static final int RETAINED_MESSAGE_QUEUE_INDEX = 0;
    private static final int CLIENT_SESSION_QUEUE_INDEX = 1;
    private static final int SUBSCRIPTION_QUEUE_INDEX = 2;
    private static final int QUEUED_MESSAGES_QUEUE_INDEX = 3;
    private static final int ATTRIBUTE_STORE_QUEUE_INDEX = 4;
    @NotNull
    private final @NotNull InMemoryProducerQueues @NotNull [] producers = new InMemoryProducerQueues[5];
    private final int persistenceBucketCount = InternalConfigurations.PERSISTENCE_BUCKET_COUNT.get();

    @Inject
    public InMemorySingleWriter() {
        int threadPoolSize = InternalConfigurations.SINGLE_WRITER_THREAD_POOL_SIZE.get();
        int amountOfQueues = this.validAmountOfQueues(threadPoolSize, this.persistenceBucketCount);
        for (int i = 0; i < this.producers.length; ++i) {
            this.producers[i] = new InMemoryProducerQueues(this.persistenceBucketCount, amountOfQueues);
        }
    }

    @VisibleForTesting
    int validAmountOfQueues(int processorCount, int bucketCount) {
        for (int i = processorCount; i < bucketCount; ++i) {
            if (bucketCount % i != 0) continue;
            return i;
        }
        return this.persistenceBucketCount;
    }

    @Override
    @NotNull
    public ProducerQueues getRetainedMessageQueue() {
        return this.producers[0];
    }

    @Override
    @NotNull
    public ProducerQueues getClientSessionQueue() {
        return this.producers[1];
    }

    @Override
    @NotNull
    public ProducerQueues getSubscriptionQueue() {
        return this.producers[2];
    }

    @Override
    @NotNull
    public ProducerQueues getQueuedMessagesQueue() {
        return this.producers[3];
    }

    @Override
    @NotNull
    public ProducerQueues getAttributeStoreQueue() {
        return this.producers[4];
    }

    @Override
    public int getPersistenceBucketCount() {
        return this.persistenceBucketCount;
    }

    @Override
    public void stop() {
        if (log.isTraceEnabled()) {
            log.trace("Shutting down single writer");
        }
    }
}

