/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.persistence;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.inject.Inject;
import com.hivemq.common.shutdown.HiveMQShutdownHook;
import com.hivemq.configuration.service.InternalConfigurations;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.persistence.SingleWriterService;
import com.hivemq.persistence.clientqueue.ClientQueuePersistence;
import com.hivemq.persistence.clientsession.ClientSessionPersistence;
import com.hivemq.persistence.clientsession.ClientSessionSubscriptionPersistence;
import com.hivemq.persistence.ioc.annotation.PayloadPersistence;
import com.hivemq.persistence.ioc.annotation.Persistence;
import com.hivemq.persistence.payload.PublishPayloadPersistence;
import com.hivemq.persistence.qos.IncomingMessageFlowPersistence;
import com.hivemq.persistence.retained.RetainedMessagePersistence;
import com.hivemq.persistence.util.FutureUtils;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistenceShutdownHook
implements HiveMQShutdownHook {
    private static final Logger log = LoggerFactory.getLogger(PersistenceShutdownHook.class);
    @NotNull
    private final ClientSessionPersistence clientSessionPersistence;
    @NotNull
    private final ClientSessionSubscriptionPersistence clientSessionSubscriptionPersistence;
    @NotNull
    private final IncomingMessageFlowPersistence incomingMessageFlowPersistence;
    @NotNull
    private final RetainedMessagePersistence retainedMessagePersistence;
    @NotNull
    private final ClientQueuePersistence clientQueuePersistence;
    @NotNull
    private final ListeningExecutorService persistenceExecutorService;
    @NotNull
    private final ListeningScheduledExecutorService persistenceScheduledExecutorService;
    @NotNull
    private final ListeningScheduledExecutorService payloadPersistenceExecutor;
    @NotNull
    private final SingleWriterService singleWriterService;
    @NotNull
    private final PublishPayloadPersistence payloadPersistence;

    @Inject
    PersistenceShutdownHook(@NotNull ClientSessionPersistence clientSessionPersistence, @NotNull ClientSessionSubscriptionPersistence clientSessionSubscriptionPersistence, @NotNull IncomingMessageFlowPersistence incomingMessageFlowPersistence, @NotNull RetainedMessagePersistence retainedMessagePersistence, @NotNull PublishPayloadPersistence payloadPersistence, @NotNull ClientQueuePersistence clientQueuePersistence, @Persistence @NotNull ListeningExecutorService persistenceExecutorService, @Persistence @NotNull ListeningScheduledExecutorService persistenceScheduledExecutorService, @PayloadPersistence @NotNull ListeningScheduledExecutorService payloadPersistenceExecutor, @NotNull SingleWriterService singleWriterService) {
        this.clientSessionPersistence = clientSessionPersistence;
        this.clientSessionSubscriptionPersistence = clientSessionSubscriptionPersistence;
        this.incomingMessageFlowPersistence = incomingMessageFlowPersistence;
        this.retainedMessagePersistence = retainedMessagePersistence;
        this.clientQueuePersistence = clientQueuePersistence;
        this.persistenceExecutorService = persistenceExecutorService;
        this.persistenceScheduledExecutorService = persistenceScheduledExecutorService;
        this.payloadPersistenceExecutor = payloadPersistenceExecutor;
        this.singleWriterService = singleWriterService;
        this.payloadPersistence = payloadPersistence;
    }

    @Override
    @NotNull
    public String name() {
        return "Persistence Shutdown";
    }

    @Override
    public void run() {
        long start = System.currentTimeMillis();
        if (log.isTraceEnabled()) {
            log.trace("Shutting down persistent stores");
        }
        this.payloadPersistenceExecutor.shutdown();
        ImmutableList.Builder builder = ImmutableList.builder();
        this.incomingMessageFlowPersistence.closeDB();
        builder.add(this.clientSessionPersistence.closeDB());
        builder.add(this.clientSessionSubscriptionPersistence.closeDB());
        builder.add(this.retainedMessagePersistence.closeDB());
        builder.add(this.clientQueuePersistence.closeDB());
        ListenableFuture<Void> combinedFuture = FutureUtils.voidFutureFromList((ImmutableList<ListenableFuture<Void>>)builder.build());
        int shutdownTimeout = InternalConfigurations.PERSISTENCE_SHUTDOWN_TIMEOUT_SEC.get();
        try {
            this.payloadPersistenceExecutor.awaitTermination((long)shutdownTimeout, TimeUnit.SECONDS);
            combinedFuture.get((long)shutdownTimeout, TimeUnit.SECONDS);
            if (log.isTraceEnabled()) {
                log.trace("Finished persistence shutdown in {} ms", (Object)(System.currentTimeMillis() - start));
            }
        }
        catch (TimeoutException te) {
            log.warn("Persistences were not closed properly");
        }
        catch (Exception e) {
            log.error("Persistences were not closed properly: {}", (Object)e.getMessage());
            log.debug("Original Exception: ", (Throwable)e);
        }
        this.payloadPersistence.closeDB();
        this.singleWriterService.stop();
        this.persistenceScheduledExecutorService.shutdownNow();
        this.persistenceExecutorService.shutdown();
    }
}

