/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.persistence.clientsession.task;

import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.persistence.SingleWriterService;
import com.hivemq.persistence.clientsession.ClientSessionPersistence;
import com.hivemq.persistence.clientsession.ClientSessionPersistenceImpl;
import com.hivemq.persistence.clientsession.PendingWillMessages;
import com.hivemq.persistence.local.ClientSessionLocalPersistence;
import com.hivemq.util.Checkpoints;
import java.util.Set;

public class ClientSessionCleanUpTask
implements SingleWriterService.Task<Void> {
    @NotNull
    private final ClientSessionLocalPersistence localPersistence;
    @NotNull
    private final ClientSessionPersistence clientSessionPersistence;
    @NotNull
    private final PendingWillMessages pendingWillMessages;

    public ClientSessionCleanUpTask(@NotNull ClientSessionLocalPersistence localPersistence, @NotNull ClientSessionPersistenceImpl clientSessionPersistence, @NotNull PendingWillMessages pendingWillMessages) {
        this.localPersistence = localPersistence;
        this.clientSessionPersistence = clientSessionPersistence;
        this.pendingWillMessages = pendingWillMessages;
    }

    @Override
    @Nullable
    public Void doTask(int bucketIndex) {
        Set<String> expiredSessions = this.localPersistence.cleanUp(bucketIndex);
        for (String expiredSession : expiredSessions) {
            this.pendingWillMessages.sendWillIfPending(expiredSession);
            this.clientSessionPersistence.cleanClientData(expiredSession);
        }
        Checkpoints.checkpoint("ClientSessionCleanUpFinished");
        return null;
    }
}

