/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.persistence.ioc.provider.local;

import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.hivemq.bootstrap.ioc.lazysingleton.LazySingleton;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.persistence.ioc.annotation.Persistence;
import com.hivemq.util.ThreadFactoryUtil;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import javax.inject.Provider;

@LazySingleton
public class PersistenceScheduledExecutorProvider
implements Provider<ListeningScheduledExecutorService> {
    @Nullable
    private ListeningScheduledExecutorService executorService;

    @LazySingleton
    @Persistence
    @NotNull
    public ListeningScheduledExecutorService get() {
        if (this.executorService == null) {
            ThreadFactory threadFactory = ThreadFactoryUtil.create("scheduled-persistence-executor");
            ScheduledExecutorService singleThreadExecutor = Executors.newSingleThreadScheduledExecutor(threadFactory);
            this.executorService = MoreExecutors.listeningDecorator((ScheduledExecutorService)singleThreadExecutor);
        }
        return this.executorService;
    }
}

