/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.persistence.local.memory;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.hivemq.annotations.ExecuteInSingleWriter;
import com.hivemq.bootstrap.ioc.lazysingleton.LazySingleton;
import com.hivemq.configuration.service.InternalConfigurations;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.extensions.iteration.BucketChunkResult;
import com.hivemq.metrics.HiveMQMetrics;
import com.hivemq.mqtt.message.subscribe.Topic;
import com.hivemq.persistence.IterablePersistenceEntry;
import com.hivemq.persistence.local.ClientSessionSubscriptionLocalPersistence;
import com.hivemq.persistence.local.xodus.bucket.BucketUtils;
import com.hivemq.util.ObjectMemoryEstimation;
import com.hivemq.util.ThreadPreConditions;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import javax.inject.Inject;

@LazySingleton
public class ClientSessionSubscriptionMemoryLocalPersistence
implements ClientSessionSubscriptionLocalPersistence {
    @NotNull
    private final @NotNull Map<String, IterablePersistenceEntry<ImmutableSet<Topic>>> @NotNull [] buckets;
    private final int bucketCount;
    @VisibleForTesting
    @NotNull
    final AtomicLong currentMemorySize = new AtomicLong();

    @Inject
    ClientSessionSubscriptionMemoryLocalPersistence(@NotNull MetricRegistry metricRegistry) {
        this.bucketCount = InternalConfigurations.PERSISTENCE_BUCKET_COUNT.get();
        this.buckets = new HashMap[this.bucketCount];
        for (int i = 0; i < this.bucketCount; ++i) {
            this.buckets[i] = new HashMap<String, IterablePersistenceEntry<ImmutableSet<Topic>>>();
        }
        metricRegistry.register(HiveMQMetrics.CLIENT_SESSION_SUBSCRIPTIONS_MEMORY_PERSISTENCE_TOTAL_SIZE.name(), (Metric)((Gauge)this.currentMemorySize::get));
    }

    @Override
    @ExecuteInSingleWriter
    public void addSubscription(@NotNull String client, @NotNull Topic topic, long timestamp, int bucketIndex) {
        this.addSubscriptions(client, (ImmutableSet<Topic>)ImmutableSet.of((Object)topic), timestamp, bucketIndex);
    }

    @Override
    @ExecuteInSingleWriter
    public void addSubscriptions(@NotNull String client, @NotNull ImmutableSet<Topic> topics, long timestamp, int bucketIndex) {
        Preconditions.checkNotNull((Object)client, (Object)"Client id must not be null");
        Preconditions.checkNotNull(topics, (Object)"Topics must not be null");
        Preconditions.checkState((timestamp > 0L ? 1 : 0) != 0, (Object)"Timestamp must not be 0");
        ThreadPreConditions.startsWith("single-writer");
        this.buckets[bucketIndex].compute(client, (ignore, oldEntry) -> {
            if (oldEntry == null) {
                IterablePersistenceEntry<ImmutableSet> newEntry = new IterablePersistenceEntry<ImmutableSet>(topics, timestamp);
                this.currentMemorySize.addAndGet(newEntry.getEstimatedSize());
                this.currentMemorySize.addAndGet(ObjectMemoryEstimation.stringSize(client));
                return newEntry;
            }
            this.currentMemorySize.addAndGet(-oldEntry.getEstimatedSize());
            IterablePersistenceEntry<ImmutableSet> mergedEntry = new IterablePersistenceEntry<ImmutableSet>(Sets.union((Set)topics, (Set)((Set)oldEntry.getObject())).immutableCopy(), timestamp);
            this.currentMemorySize.addAndGet(mergedEntry.getEstimatedSize());
            return mergedEntry;
        });
    }

    @Override
    @ExecuteInSingleWriter
    public void remove(@NotNull String client, @NotNull String topic, long timestamp, int bucketIndex) {
        Preconditions.checkNotNull((Object)client, (Object)"Clientid must not be null");
        Preconditions.checkNotNull((Object)topic, (Object)"Topic must not be null");
        Preconditions.checkState((timestamp > 0L ? 1 : 0) != 0, (Object)"Timestamp must not be 0");
        this.removeSubscriptions(client, (ImmutableSet<String>)ImmutableSet.of((Object)topic), timestamp, bucketIndex);
    }

    @Override
    @ExecuteInSingleWriter
    public void removeSubscriptions(@NotNull String client, @NotNull ImmutableSet<String> topics, long timestamp, int bucketIndex) {
        Preconditions.checkNotNull((Object)client, (Object)"Client id must not be null");
        Preconditions.checkNotNull(topics, (Object)"Topics must not be null");
        Preconditions.checkState((timestamp > 0L ? 1 : 0) != 0, (Object)"Timestamp must not be 0");
        ThreadPreConditions.startsWith("single-writer");
        this.buckets[bucketIndex].computeIfPresent(client, (ignore, entry) -> {
            ImmutableSet.Builder remainingTopicsBuilder = new ImmutableSet.Builder();
            boolean remaining = false;
            for (Topic topic : (ImmutableSet)entry.getObject()) {
                if (topics.contains((Object)topic.getTopic())) {
                    this.currentMemorySize.addAndGet(-(topic.getEstimatedSize() + ObjectMemoryEstimation.objectRefSize()));
                    continue;
                }
                remaining = true;
                remainingTopicsBuilder.add((Object)topic);
            }
            if (!remaining) {
                this.currentMemorySize.addAndGet(-IterablePersistenceEntry.getFixedSize());
                this.currentMemorySize.addAndGet(-ObjectMemoryEstimation.stringSize(client));
                return null;
            }
            return new IterablePersistenceEntry<ImmutableSet>(remainingTopicsBuilder.build(), timestamp);
        });
    }

    @Override
    @ExecuteInSingleWriter
    public void removeAll(@NotNull String client, long timestamp, int bucketIndex) {
        Preconditions.checkNotNull((Object)client, (Object)"Clientid must not be null");
        Preconditions.checkState((timestamp > 0L ? 1 : 0) != 0, (Object)"Timestamp must not be 0");
        ThreadPreConditions.startsWith("single-writer");
        IterablePersistenceEntry<ImmutableSet<Topic>> remove = this.buckets[bucketIndex].remove(client);
        if (remove == null) {
            return;
        }
        this.currentMemorySize.addAndGet(-remove.getEstimatedSize());
        this.currentMemorySize.addAndGet(-ObjectMemoryEstimation.stringSize(client));
    }

    @Override
    @NotNull
    public ImmutableSet<Topic> getSubscriptions(@NotNull String client) {
        Preconditions.checkNotNull((Object)client, (Object)"Clientid must not be null");
        IterablePersistenceEntry<ImmutableSet<Topic>> entry = this.buckets[BucketUtils.getBucket(client, this.bucketCount)].get(client);
        if (entry == null) {
            return ImmutableSet.of();
        }
        return entry.getObject();
    }

    @Override
    @NotNull
    public BucketChunkResult<Map<String, ImmutableSet<Topic>>> getAllSubscribersChunk(int bucketIndex, @Nullable String lastClientIdIgnored, int maxResultsIgnored) {
        Map<String, ImmutableSet> result = this.buckets[bucketIndex].entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (ImmutableSet)((IterablePersistenceEntry)e.getValue()).getObject()));
        return new BucketChunkResult<Map<String, ImmutableSet<Topic>>>(result, true, lastClientIdIgnored, bucketIndex);
    }

    @Override
    public void cleanUp(int bucket) {
    }

    @Override
    public void closeDB(int bucketIndex) {
        this.buckets[bucketIndex].clear();
        this.currentMemorySize.set(0L);
    }
}

