/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.persistence.local.xodus;

import com.google.common.base.Preconditions;
import com.hivemq.configuration.service.InternalConfigurations;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.migration.meta.PersistenceType;
import javax.inject.Singleton;
import jetbrains.exodus.env.EnvironmentConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class EnvironmentUtil {
    private static final Logger log = LoggerFactory.getLogger(EnvironmentUtil.class);

    public EnvironmentConfig createEnvironmentConfig(@NotNull String name) {
        Preconditions.checkNotNull((Object)name, (Object)"Name for environment config must not be null");
        return this.createEnvironmentConfig(2, 60000, 1, 30000, InternalConfigurations.XODUS_PERSISTENCE_ENVIRONMENT_GC_TYPE, 1000, false, false, name);
    }

    public EnvironmentConfig createEnvironmentConfig(int gcMinAge, int gcDeletionDelay, int gcFilesInterval, int gcRunPeriod, @NotNull GCType gcType, int syncPeriod, boolean durableWrites, boolean jmxEnabled, @NotNull String name) {
        Preconditions.checkNotNull((Object)name, (Object)"Name for environment config must not be null");
        Preconditions.checkNotNull((Object)((Object)gcType), (String)"Garbage Collection Type for %s must not be null", (Object)name);
        EnvironmentConfig environmentConfig = new EnvironmentConfig();
        environmentConfig.setGcFileMinAge(gcMinAge);
        log.trace("Setting GC file min age for persistence {} to {}", (Object)name, (Object)gcMinAge);
        environmentConfig.setGcFilesDeletionDelay(gcDeletionDelay);
        log.trace("Setting GC files deletion delay for persistence {} to {}ms", (Object)name, (Object)gcDeletionDelay);
        environmentConfig.setGcFilesInterval(gcFilesInterval);
        log.trace("Setting GC files interval for persistence {} to {}ms", (Object)name, (Object)gcFilesInterval);
        environmentConfig.setGcRunPeriod(gcRunPeriod);
        log.trace("Setting GC run period for persistence {} to {}ms", (Object)name, (Object)gcRunPeriod);
        if (gcType == GCType.RENAME) {
            environmentConfig.setGcRenameFiles(true);
        }
        log.trace("Setting mode for persistence {} to {}", (Object)name, (Object)gcType.name());
        environmentConfig.setLogSyncPeriod((long)syncPeriod);
        log.trace("Setting sync period for persistence {} to {}ms", (Object)name, (Object)syncPeriod);
        environmentConfig.setLogDurableWrite(durableWrites);
        log.trace("Setting durable writes for persistence {} to {}", (Object)name, (Object)durableWrites);
        environmentConfig.setManagementEnabled(jmxEnabled);
        log.trace("Setting JMX enabled for persistence {} to {}", (Object)name, (Object)jmxEnabled);
        environmentConfig.setLogCacheUseNio(false);
        PersistenceType payloadPersistenceType = InternalConfigurations.PAYLOAD_PERSISTENCE_TYPE.get();
        PersistenceType retainedMessagePersistenceType = InternalConfigurations.RETAINED_MESSAGE_PERSISTENCE_TYPE.get();
        if (payloadPersistenceType != PersistenceType.FILE && retainedMessagePersistenceType != PersistenceType.FILE) {
            int logCacheMemory = 25;
            log.trace("Setting log cache memory percentage for persistence {} to {}", (Object)name, (Object)25);
            environmentConfig.setMemoryUsagePercentage(25);
        }
        return environmentConfig;
    }

    public static enum GCType {
        DELETE,
        RENAME;

    }
}

