/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.persistence.local.xodus;

import com.google.common.base.Preconditions;
import com.hivemq.configuration.service.InternalConfigurations;
import com.hivemq.exceptions.UnrecoverableException;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.persistence.FilePersistence;
import com.hivemq.persistence.LocalPersistence;
import com.hivemq.persistence.PersistenceStartup;
import com.hivemq.persistence.local.xodus.EnvironmentCloser;
import com.hivemq.persistence.local.xodus.EnvironmentUtil;
import com.hivemq.persistence.local.xodus.bucket.Bucket;
import com.hivemq.persistence.local.xodus.bucket.BucketUtils;
import com.hivemq.util.LocalPersistenceFileUtil;
import java.io.File;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import jetbrains.exodus.ExodusException;
import jetbrains.exodus.env.ContextualEnvironment;
import jetbrains.exodus.env.Environment;
import jetbrains.exodus.env.EnvironmentConfig;
import jetbrains.exodus.env.Environments;
import jetbrains.exodus.env.Store;
import jetbrains.exodus.env.StoreConfig;
import jetbrains.exodus.env.Transaction;
import jetbrains.exodus.io.DataWriter;
import jetbrains.exodus.io.FileDataWriter;
import jetbrains.exodus.log.LogConfig;
import org.slf4j.Logger;

public abstract class XodusLocalPersistence
implements LocalPersistence,
FilePersistence {
    @NotNull
    private final EnvironmentUtil environmentUtil;
    @NotNull
    private final LocalPersistenceFileUtil localPersistenceFileUtil;
    @NotNull
    private final PersistenceStartup persistenceStartup;
    @NotNull
    protected final AtomicBoolean stopped = new AtomicBoolean(false);
    @NotNull
    protected Bucket[] buckets;
    protected int bucketCount;
    private final boolean enabled;
    private final int closeRetries;
    private final int closeRetryInterval;

    protected XodusLocalPersistence(@NotNull EnvironmentUtil environmentUtil, @NotNull LocalPersistenceFileUtil localPersistenceFileUtil, @NotNull PersistenceStartup persistenceStartup, int bucketCount, boolean enabled) {
        this.environmentUtil = environmentUtil;
        this.localPersistenceFileUtil = localPersistenceFileUtil;
        this.persistenceStartup = persistenceStartup;
        this.bucketCount = bucketCount;
        this.buckets = new Bucket[bucketCount];
        this.enabled = enabled;
        this.closeRetries = InternalConfigurations.PERSISTENCE_CLOSE_RETRIES.get();
        this.closeRetryInterval = InternalConfigurations.PERSISTENCE_CLOSE_RETRY_INTERVAL_MSEC.get();
    }

    @NotNull
    protected abstract String getName();

    @NotNull
    protected abstract String getVersion();

    public int getBucketCount() {
        return this.bucketCount;
    }

    @NotNull
    protected abstract StoreConfig getStoreConfig();

    @NotNull
    protected abstract Logger getLogger();

    protected void postConstruct() {
        if (this.enabled) {
            this.persistenceStartup.submitPersistenceStart(this);
        } else {
            this.startExternal();
        }
    }

    @Override
    public void startExternal() {
        String name = this.getName();
        String version = this.getVersion();
        StoreConfig storeConfig = this.getStoreConfig();
        Logger logger = this.getLogger();
        try {
            EnvironmentConfig environmentConfig = this.environmentUtil.createEnvironmentConfig(name);
            File persistenceFolder = this.localPersistenceFileUtil.getVersionedLocalPersistenceFolder(name, version);
            for (int i = 0; i < this.bucketCount; ++i) {
                File persistenceFile = new File(persistenceFolder, name + "_" + i);
                if (!persistenceFile.exists() && !persistenceFile.mkdirs()) {
                    logger.error("Failed to create directory: {}", (Object)persistenceFile);
                    throw new UnrecoverableException();
                }
                LogConfig logConfig = new LogConfig();
                logConfig.setDir(persistenceFile);
                logConfig.setWriter((DataWriter)new XodusNoLockDataWriter(persistenceFile, logConfig));
                ContextualEnvironment environment = Environments.newContextualInstance((LogConfig)logConfig, (EnvironmentConfig)environmentConfig);
                Store store = (Store)environment.computeInTransaction(arg_0 -> XodusLocalPersistence.lambda$startExternal$0((Environment)environment, name, storeConfig, arg_0));
                this.buckets[i] = new Bucket((Environment)environment, store);
            }
        }
        catch (ExodusException e) {
            logger.error("An error occurred while opening the {} persistence. Is another HiveMQ instance running?", (Object)name);
            logger.info("Original Exception:", (Throwable)e);
            throw new UnrecoverableException();
        }
        this.init();
    }

    @Override
    public void start() {
        String name = this.getName();
        String version = this.getVersion();
        StoreConfig storeConfig = this.getStoreConfig();
        Logger logger = this.getLogger();
        try {
            EnvironmentConfig environmentConfig = this.environmentUtil.createEnvironmentConfig(name);
            File persistenceFolder = this.localPersistenceFileUtil.getVersionedLocalPersistenceFolder(name, version);
            CountDownLatch counter = new CountDownLatch(this.bucketCount);
            int i = 0;
            while (i < this.bucketCount) {
                int finalI = i++;
                this.persistenceStartup.submitEnvironmentCreate(() -> {
                    File persistenceFile = new File(persistenceFolder, name + "_" + finalI);
                    if (!persistenceFile.exists() && !persistenceFile.mkdirs()) {
                        throw new ExodusException("Failed to create directory: " + String.valueOf(persistenceFile));
                    }
                    LogConfig logConfig = new LogConfig();
                    logConfig.setDir(persistenceFile);
                    logConfig.setWriter((DataWriter)new XodusNoLockDataWriter(persistenceFile, logConfig));
                    ContextualEnvironment environment = Environments.newContextualInstance((LogConfig)logConfig, (EnvironmentConfig)environmentConfig);
                    Store store = (Store)environment.computeInTransaction(arg_0 -> XodusLocalPersistence.lambda$start$1((Environment)environment, name, storeConfig, arg_0));
                    this.buckets[finalI] = new Bucket((Environment)environment, store);
                    counter.countDown();
                });
            }
            counter.await();
        }
        catch (InterruptedException | ExodusException e) {
            logger.error("An error occurred while opening the {} persistence. Is another HiveMQ instance running?", (Object)name);
            logger.info("Original Exception:", e);
            throw new UnrecoverableException();
        }
        this.init();
    }

    protected abstract void init();

    @Override
    public void stop() {
        this.stopped.set(true);
        this.closeDB();
    }

    public void closeDB() {
        for (int i = 0; i < this.bucketCount; ++i) {
            this.closeDB(i);
        }
    }

    @Override
    public void closeDB(int bucketIndex) {
        this.checkBucketIndex(bucketIndex);
        Bucket bucket = this.buckets[bucketIndex];
        if (bucket == null) {
            return;
        }
        if (bucket.close() && bucket.getEnvironment().isOpen()) {
            new EnvironmentCloser(this.getName() + "-closer", bucket.getEnvironment(), this.closeRetries, this.closeRetryInterval).close();
        }
    }

    @NotNull
    public Bucket getBucket(@NotNull String key) {
        return this.buckets[BucketUtils.getBucket(key, this.bucketCount)];
    }

    protected void checkBucketIndex(int bucketIndex) {
        Preconditions.checkArgument((bucketIndex >= 0 && bucketIndex < this.buckets.length ? 1 : 0) != 0, (Object)("Invalid bucket index: " + bucketIndex));
    }

    private static /* synthetic */ Store lambda$start$1(Environment environment, String name, StoreConfig storeConfig, Transaction txn) {
        return environment.openStore(name, storeConfig, txn);
    }

    private static /* synthetic */ Store lambda$startExternal$0(Environment environment, String name, StoreConfig storeConfig, Transaction txn) {
        return environment.openStore(name, storeConfig, txn);
    }

    private static final class XodusNoLockDataWriter
    extends FileDataWriter {
        private XodusNoLockDataWriter(@NotNull File persistenceFile, @NotNull LogConfig logConfig) {
            super(persistenceFile, logConfig.getLockId());
        }

        public boolean lock(long timeout) {
            return true;
        }
    }
}

