/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.persistence.local.xodus.clientsession;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.hivemq.bootstrap.ioc.lazysingleton.LazySingleton;
import com.hivemq.configuration.service.InternalConfigurations;
import com.hivemq.exceptions.UnrecoverableException;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.extensions.iteration.BucketChunkResult;
import com.hivemq.mqtt.message.subscribe.Topic;
import com.hivemq.persistence.PersistenceStartup;
import com.hivemq.persistence.local.ClientSessionSubscriptionLocalPersistence;
import com.hivemq.persistence.local.xodus.EnvironmentUtil;
import com.hivemq.persistence.local.xodus.XodusLocalPersistence;
import com.hivemq.persistence.local.xodus.XodusUtils;
import com.hivemq.persistence.local.xodus.bucket.Bucket;
import com.hivemq.persistence.local.xodus.bucket.BucketUtils;
import com.hivemq.persistence.local.xodus.clientsession.ClientSessionSubscriptionXodusSerializer;
import com.hivemq.util.LocalPersistenceFileUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.ExodusException;
import jetbrains.exodus.env.Cursor;
import jetbrains.exodus.env.StoreConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LazySingleton
public class ClientSessionSubscriptionXodusLocalPersistence
extends XodusLocalPersistence
implements ClientSessionSubscriptionLocalPersistence {
    private static final Logger log = LoggerFactory.getLogger(ClientSessionSubscriptionXodusLocalPersistence.class);
    private static final String PERSISTENCE_NAME = "client_session_subscriptions";
    public static final String PERSISTENCE_VERSION = "040000";
    @VisibleForTesting
    @NotNull
    final ClientSessionSubscriptionXodusSerializer serializer;
    private final AtomicLong nextId = new AtomicLong();

    @Inject
    ClientSessionSubscriptionXodusLocalPersistence(@NotNull LocalPersistenceFileUtil localPersistenceFileUtil, @NotNull EnvironmentUtil environmentUtil, @NotNull PersistenceStartup persistenceStartup) {
        super(environmentUtil, localPersistenceFileUtil, persistenceStartup, InternalConfigurations.PERSISTENCE_BUCKET_COUNT.get(), true);
        this.serializer = new ClientSessionSubscriptionXodusSerializer();
    }

    @Override
    @NotNull
    protected String getName() {
        return PERSISTENCE_NAME;
    }

    @Override
    @NotNull
    protected String getVersion() {
        return PERSISTENCE_VERSION;
    }

    @Override
    @NotNull
    protected StoreConfig getStoreConfig() {
        return StoreConfig.WITH_DUPLICATES_WITH_PREFIXING;
    }

    @Override
    @NotNull
    protected Logger getLogger() {
        return log;
    }

    @Override
    @PostConstruct
    protected void postConstruct() {
        super.postConstruct();
    }

    @Override
    protected void init() {
        try {
            for (int i = 0; i < this.bucketCount; ++i) {
                Bucket bucket = this.buckets[i];
                bucket.getEnvironment().executeInReadonlyTransaction(txn -> {
                    try (Cursor cursor = bucket.getStore().openCursor(txn);){
                        while (cursor.getNext()) {
                            long id = this.serializer.deserializeId(XodusUtils.byteIterableToBytes(cursor.getValue()));
                            if (this.nextId.get() >= id) continue;
                            this.nextId.set(id);
                        }
                    }
                });
            }
            this.nextId.incrementAndGet();
        }
        catch (ExodusException e) {
            log.error("An error occurred while preparing the Client Session Subscription persistence.");
            log.debug("Original Exception:", (Throwable)e);
            throw new UnrecoverableException(false);
        }
    }

    @Override
    public void addSubscription(@NotNull String client, @NotNull Topic topic, long timestamp, int bucketIndex) {
        Preconditions.checkNotNull((Object)client, (Object)"Clientid must not be null");
        Preconditions.checkNotNull((Object)topic, (Object)"Topic must not be null");
        Preconditions.checkNotNull((Object)topic.getTopic(), (Object)"Topic must not be null");
        Preconditions.checkState((timestamp > 0L ? 1 : 0) != 0, (Object)"Timestamp must not be 0");
        Bucket bucket = this.buckets[bucketIndex];
        bucket.getEnvironment().executeInTransaction(txn -> {
            ByteIterable key = XodusUtils.bytesToByteIterable(this.serializer.serializeKey(client));
            bucket.getStore().put(txn, key, XodusUtils.bytesToByteIterable(this.serializer.serializeValue(topic, timestamp, this.nextId.getAndIncrement())));
        });
    }

    @Override
    public void addSubscriptions(@NotNull String client, @NotNull ImmutableSet<Topic> topics, long timestamp, int bucketIndex) {
        Preconditions.checkNotNull((Object)client, (Object)"Client id must not be null");
        Preconditions.checkNotNull(topics, (Object)"Topics must not be null");
        Preconditions.checkState((timestamp > 0L ? 1 : 0) != 0, (Object)"Timestamp must not be 0");
        Bucket bucket = this.buckets[bucketIndex];
        bucket.getEnvironment().executeInTransaction(txn -> {
            for (Topic topic : topics) {
                long rowId = this.nextId.getAndIncrement();
                ByteIterable key = XodusUtils.bytesToByteIterable(this.serializer.serializeKey(client));
                bucket.getStore().put(txn, key, XodusUtils.bytesToByteIterable(this.serializer.serializeValue(topic, timestamp, rowId)));
            }
        });
    }

    @Override
    public void removeSubscriptions(@NotNull String client, @NotNull ImmutableSet<String> topics, long timestamp, int bucketIndex) {
        Preconditions.checkNotNull((Object)client, (Object)"Client id must not be null");
        Preconditions.checkNotNull(topics, (Object)"Topics must not be null");
        Preconditions.checkState((timestamp > 0L ? 1 : 0) != 0, (Object)"Timestamp must not be 0");
        Bucket bucket = this.buckets[bucketIndex];
        bucket.getEnvironment().executeInTransaction(txn -> {
            try (Cursor cursor = bucket.getStore().openCursor(txn);){
                ByteIterable clientByteIterable = XodusUtils.bytesToByteIterable(this.serializer.serializeKey(client));
                if (cursor.getSearchKey(clientByteIterable) == null) {
                    return;
                }
                do {
                    Topic topic;
                    if (!topics.contains((Object)(topic = this.serializer.deserializeValue(XodusUtils.byteIterableToBytes(cursor.getValue()))).getTopic())) continue;
                    cursor.deleteCurrent();
                } while (cursor.getNextDup());
            }
        });
    }

    @Override
    @NotNull
    public ImmutableSet<Topic> getSubscriptions(@NotNull String client) {
        Preconditions.checkNotNull((Object)client, (Object)"Clientid must not be null");
        Bucket bucket = this.buckets[BucketUtils.getBucket(client, this.bucketCount)];
        return (ImmutableSet)bucket.getEnvironment().computeInReadonlyTransaction(txn -> {
            HashMap<Topic, Long> results = new HashMap<Topic, Long>();
            try (Cursor cursor = bucket.getStore().openCursor(txn);){
                ByteIterable firstEntry = cursor.getSearchKey(XodusUtils.bytesToByteIterable(this.serializer.serializeKey(client)));
                if (firstEntry == null) {
                    ImmutableSet immutableSet = ImmutableSet.of();
                    return immutableSet;
                }
                do {
                    byte[] bytes = XodusUtils.byteIterableToBytes(cursor.getValue());
                    Topic value = this.serializer.deserializeValue(bytes);
                    long id = this.serializer.deserializeId(bytes);
                    Long valueFromMap = (Long)results.get(value);
                    if (valueFromMap == null) {
                        results.put(value, id);
                        continue;
                    }
                    if (valueFromMap >= id) continue;
                    results.remove(value);
                    results.put(value, id);
                } while (cursor.getNextDup());
            }
            return ImmutableSet.copyOf(results.keySet());
        });
    }

    @Override
    public void removeAll(@NotNull String client, long timestamp, int bucketIndex) {
        Preconditions.checkNotNull((Object)client, (Object)"Clientid must not be null");
        Preconditions.checkState((timestamp > 0L ? 1 : 0) != 0, (Object)"Timestamp must not be 0");
        Bucket bucket = this.buckets[bucketIndex];
        bucket.getEnvironment().executeInTransaction(txn -> {
            try (Cursor cursor = bucket.getStore().openCursor(txn);){
                this.removeClientFromCursor(client, cursor);
            }
        });
    }

    @Override
    public void remove(@NotNull String client, @NotNull String topic, long timestamp, int bucketIndex) {
        Preconditions.checkNotNull((Object)client, (Object)"Clientid must not be null");
        Preconditions.checkNotNull((Object)topic, (Object)"Topic must not be null");
        Preconditions.checkState((timestamp > 0L ? 1 : 0) != 0, (Object)"Timestamp must not be 0");
        this.removeSubscriptions(client, (ImmutableSet<String>)ImmutableSet.of((Object)topic), timestamp, bucketIndex);
    }

    @Override
    @NotNull
    public BucketChunkResult<Map<String, ImmutableSet<Topic>>> getAllSubscribersChunk(int bucketIndex, @Nullable String lastClientId, int maxResults) {
        Preconditions.checkArgument((maxResults > 0 ? 1 : 0) != 0, (Object)"max results must be greater than 0");
        ImmutableMap.Builder resultBuilder = ImmutableMap.builder();
        Bucket bucket = this.buckets[bucketIndex];
        return (BucketChunkResult)bucket.getEnvironment().computeInReadonlyTransaction(txn -> {
            String lastKey = null;
            int containedItemCount = 0;
            try (Cursor cursor = bucket.getStore().openCursor(txn);){
                ByteIterable key;
                ByteIterable lastClientIdKey;
                ByteIterable byteIterable = lastClientIdKey = lastClientId != null ? XodusUtils.bytesToByteIterable(this.serializer.serializeKey(lastClientId)) : null;
                if (lastClientIdKey != null) {
                    cursor.getSearchKeyRange(lastClientIdKey);
                    if (cursor.getKey().equals(lastClientIdKey)) {
                        cursor.getNextNoDup();
                    }
                } else {
                    cursor.getNext();
                }
                while ((key = cursor.getKey()).getLength() >= 1) {
                    if (lastClientIdKey == null || lastClientIdKey.compareTo((Object)key) < 0) {
                        String clientId = this.serializer.deserializeKey(XodusUtils.byteIterableToBytes(key));
                        HashMap<Topic, Long> topicMap = new HashMap<Topic, Long>();
                        do {
                            long id = this.serializer.deserializeId(XodusUtils.byteIterableToBytes(cursor.getValue()));
                            Topic topic = this.serializer.deserializeValue(cursor.getValue());
                            Long valueFromMap = (Long)topicMap.get(topic);
                            if (valueFromMap == null) {
                                topicMap.put(topic, id);
                                continue;
                            }
                            if (valueFromMap >= id) continue;
                            topicMap.remove(topic);
                            topicMap.put(topic, id);
                        } while (cursor.getNextDup());
                        lastKey = clientId;
                        if (topicMap.size() > 0) {
                            ImmutableSet topicSet = ImmutableSet.copyOf(topicMap.keySet());
                            resultBuilder.put((Object)clientId, (Object)topicSet);
                            if ((containedItemCount += topicSet.size()) >= maxResults) {
                                BucketChunkResult<ImmutableMap> bucketChunkResult = new BucketChunkResult<ImmutableMap>(resultBuilder.build(), !cursor.getNext(), lastKey, bucketIndex);
                                return bucketChunkResult;
                            }
                        }
                    }
                    if (cursor.getNextNoDup()) continue;
                }
                BucketChunkResult<ImmutableMap> bucketChunkResult = new BucketChunkResult<ImmutableMap>(resultBuilder.build(), true, lastKey, bucketIndex);
                return bucketChunkResult;
            }
        });
    }

    @Override
    public void cleanUp(int bucket) {
        if (this.stopped.get()) {
            return;
        }
        this.cleanDuplicateEntries(bucket);
    }

    @VisibleForTesting
    void cleanDuplicateEntries(int bucketIndex) {
        Bucket bucket = this.buckets[bucketIndex];
        bucket.getEnvironment().executeInTransaction(txn -> {
            try (Cursor cursor = bucket.getStore().openCursor(txn);){
                cursor.getNext();
                if (cursor.getKey().getLength() < 1) {
                    return;
                }
                do {
                    Topic topic;
                    long id;
                    HashMap<String, Long> maxIds = new HashMap<String, Long>();
                    do {
                        id = this.serializer.deserializeId(XodusUtils.byteIterableToBytes(cursor.getValue()));
                        topic = this.serializer.deserializeValue(cursor.getValue());
                        Long maxId = (Long)maxIds.get(topic.getTopic());
                        if (maxId == null) {
                            maxIds.put(topic.getTopic(), id);
                            continue;
                        }
                        if (maxId < id) {
                            maxIds.put(topic.getTopic(), id);
                            continue;
                        }
                        cursor.deleteCurrent();
                    } while (cursor.getNextDup());
                    cursor.getSearchKey(cursor.getKey());
                    do {
                        if ((id = this.serializer.deserializeId(XodusUtils.byteIterableToBytes(cursor.getValue()))) >= (Long)maxIds.get((topic = this.serializer.deserializeValue(cursor.getValue())).getTopic())) continue;
                        cursor.deleteCurrent();
                    } while (cursor.getNextDup());
                } while (cursor.getNextNoDup());
            }
        });
    }

    private void removeClientFromCursor(@NotNull String client, @NotNull Cursor cursor) {
        ByteIterable firstEntry = cursor.getSearchKey(XodusUtils.bytesToByteIterable(this.serializer.serializeKey(client)));
        if (firstEntry == null) {
            return;
        }
        do {
            cursor.deleteCurrent();
        } while (cursor.getNextDup());
    }
}

