/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.security.ssl;

import com.google.inject.Inject;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.logging.LoggingUtils;
import com.hivemq.mqtt.handler.disconnect.MqttServerDisconnector;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.ssl.SslHandler;
import java.util.List;

public class NonSslHandler
extends ByteToMessageDecoder {
    @NotNull
    private final MqttServerDisconnector mqttServerDisconnector;

    @Inject
    public NonSslHandler(@NotNull MqttServerDisconnector mqttServerDisconnector) {
        this.mqttServerDisconnector = mqttServerDisconnector;
    }

    protected void decode(@NotNull ChannelHandlerContext ctx, @NotNull ByteBuf in, @NotNull List<Object> out) throws Exception {
        boolean isMqttPacket;
        if (in.readableBytes() < 11) {
            return;
        }
        boolean encrypted = SslHandler.isEncrypted((ByteBuf)in);
        boolean isConnectPacket = in.getUnsignedByte(0) == 16;
        boolean bl = isMqttPacket = in.getUnsignedByte(7) == 77 && in.getUnsignedByte(8) == 81 && in.getUnsignedByte(9) == 84 && in.getUnsignedByte(10) == 84;
        if (!(!encrypted || isConnectPacket && isMqttPacket)) {
            Channel channel = ctx.channel();
            String eventLogMessage = LoggingUtils.appendListenerToMessage(channel, "SSL connection to non-SSL listener");
            this.mqttServerDisconnector.logAndClose(channel, "SSL connection on non-SSL listener, dropping connection for client with IP '{}'", eventLogMessage);
            in.clear();
            return;
        }
        ctx.pipeline().remove((ChannelHandler)this);
    }
}

